/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi.distributed;

import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanNotifier;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanService;
import com.sun.ejb.spi.distributed.ReadOnlyBeanRefreshEventHandler;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class DistributedReadOnlyBeanServiceImpl
implements DistributedReadOnlyBeanService {
    private Logger _logger = LogDomains.getLogger(DistributedReadOnlyBeanServiceImpl.class, (String)"javax.enterprise.system.container.ejb");
    private ConcurrentHashMap<Long, ReadOnlyBeanRefreshHandlerInfo> refreshHandlers = new ConcurrentHashMap();
    private DistributedReadOnlyBeanNotifier robNotifier;

    DistributedReadOnlyBeanServiceImpl() {
    }

    public void setDistributedReadOnlyBeanNotifier(DistributedReadOnlyBeanNotifier notifier) {
        this.robNotifier = notifier;
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanNotifier: " + notifier);
    }

    public void addReadOnlyBeanRefreshEventHandler(long ejbID, ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
        this.refreshHandlers.put(ejbID, new ReadOnlyBeanRefreshHandlerInfo(ejbID, loader, handler));
        this._logger.log(Level.INFO, "Registered ReadOnlyBeanRefreshEventHandler: " + ejbID + "; " + handler);
    }

    public void removeReadOnlyBeanRefreshEventHandler(long ejbID) {
        this.refreshHandlers.remove(ejbID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRefresh(long ejbID, Object pk) {
        if (this.robNotifier != null) {
            byte[] pkData = null;
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(pk);
                oos.flush();
                bos.flush();
                pkData = bos.toByteArray();
                this.robNotifier.notifyRefresh(ejbID, pkData);
            }
            catch (Exception ex) {
                this._logger.log(Level.WARNING, "Error during notifyRefresh", ex);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioEx) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ioEx) {}
                }
            }
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefresh: " + ejbID);
        }
    }

    public void notifyRefreshAll(long ejbID) {
        if (this.robNotifier != null) {
            this.robNotifier.notifyRefreshAll(ejbID);
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "DistributedReadOnlyBeanService ignoring request for notifyRefreshAll: " + ejbID);
        }
    }

    public void handleRefreshRequest(long ejbID, byte[] pkData) {
        this.refreshRequestReceived(false, ejbID, pkData);
    }

    public void handleRefreshAllRequest(long ejbID) {
        this.refreshRequestReceived(true, ejbID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshRequestReceived(boolean refreshAll, long ejbID, byte[] pkData) {
        ClassLoader prevClassLoader;
        Thread currentThread;
        block41: {
            final ReadOnlyBeanRefreshHandlerInfo info = this.refreshHandlers.get(ejbID);
            if (info == null) {
                return;
            }
            currentThread = Thread.currentThread();
            prevClassLoader = currentThread.getContextClassLoader();
            try {
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(info.loader);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            currentThread.setContextClassLoader(info.loader);
                            return null;
                        }
                    });
                }
                if (!refreshAll) {
                    ByteArrayInputStream bis = null;
                    ObjectInputStream ois = null;
                    Serializable pk = null;
                    try {
                        bis = new ByteArrayInputStream(pkData);
                        ois = new ObjectInputStream(bis);
                        pk = (Serializable)ois.readObject();
                    }
                    catch (IOException ioEx) {
                        this._logger.log(Level.WARNING, "Error during refresh", ioEx);
                    }
                    catch (ClassNotFoundException cnfEx) {
                        this._logger.log(Level.WARNING, "Error during refresh", cnfEx);
                    }
                    finally {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException ioEx) {
                                this._logger.log(Level.WARNING, "Error while closing object stream", ioEx);
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException ioEx) {
                                this._logger.log(Level.WARNING, "Error while closing byte stream", ioEx);
                            }
                        }
                    }
                    if (pk != null) {
                        info.handler.handleRefreshRequest(pk);
                    }
                    break block41;
                }
                info.handler.handleRefreshAllRequest();
            }
            catch (Exception ex) {
                try {
                    this._logger.log(Level.WARNING, "Error during refresh", ex);
                }
                catch (Throwable throwable) {
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(prevClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(currentThread, prevClassLoader){
                            final /* synthetic */ Thread val$currentThread;
                            final /* synthetic */ ClassLoader val$prevClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$prevClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$prevClassLoader);
                                return null;
                            }
                        });
                    }
                    throw throwable;
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(prevClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(prevClassLoader);
        } else {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private static class ReadOnlyBeanRefreshHandlerInfo {
        public long ejbId;
        public ClassLoader loader;
        public ReadOnlyBeanRefreshEventHandler handler;

        public ReadOnlyBeanRefreshHandlerInfo(long ejbId, ClassLoader loader, ReadOnlyBeanRefreshEventHandler handler) {
            this.ejbId = ejbId;
            this.loader = loader;
            this.handler = handler;
        }
    }
}

