/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import java.util.Set;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.ejb.spi.CMPService;
import org.glassfish.ejb.startup.EjbApplication;
import org.glassfish.ejb.startup.EjbContainerStarter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EjbDeployer
extends JavaEEDeployer<EjbContainerStarter, EjbApplication> {
    @Inject
    protected ServerContext sc;
    @Inject
    protected Domain domain;
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    protected Habitat habitat;
    @Inject
    protected PolicyLoader policyLoader;
    @Inject
    protected EJBSecurityManagerFactory ejbSecManagerFactory;
    protected CMPDeployer cmpDeployer;

    protected String getModuleType() {
        return "ejb";
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{EjbBundleDescriptor.class}, new Class[]{Application.class});
    }

    public EjbApplication load(EjbContainerStarter containerStarter, DeploymentContext dc) {
        super.load((Container)containerStarter, dc);
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle.containsCMPEntity()) {
            CMPService cmpService = (CMPService)this.habitat.getByContract(CMPService.class);
            if (cmpService == null) {
                throw new RuntimeException("CMP Module is not available");
            }
            if (!cmpService.isReady()) {
                throw new RuntimeException("CMP Module is not initialized");
            }
        }
        Set ebds = ejbBundle.getEjbs();
        EjbApplication ejbApp = new EjbApplication(ebds, dc, dc.getClassLoader(), this.habitat, this.policyLoader, this.ejbSecManagerFactory);
        ejbApp.loadAndStartContainers((ApplicationContext)dc);
        return ejbApp;
    }

    public void unload(EjbApplication ejbApplication, DeploymentContext dc) {
    }

    public void clean(DeploymentContext dc) {
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.deploy) {
            return;
        }
        EjbBundleDescriptor bundle = (EjbBundleDescriptor)dc.getModuleMetaData(EjbBundleDescriptor.class);
        if (bundle == null || !bundle.containsCMPEntity()) {
            return;
        }
        this.cmpDeployer = (CMPDeployer)this.habitat.getByContract(CMPDeployer.class);
        if (this.cmpDeployer == null) {
            throw new DeploymentException("No CMP Deployer is available to deploy this module");
        }
        this.cmpDeployer.deploy(dc);
    }
}

