/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.comet.concurrent.DefaultConcurrentCometHandler;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometContext<E> {
    protected static final String INVALID_COMET_HANDLER = "CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.";
    protected static final String ALREADY_REMOVED = "CometHandler already been removed or invalid.";
    protected static final Logger logger = SelectorThread.logger();
    private final ConcurrentHashMap attributes;
    protected String topic;
    protected CometSelector cometSelector;
    protected int continuationType = 1;
    private long expirationDelay = 30000L;
    protected boolean blockingNotification = false;
    protected NotificationHandler notificationHandler;
    private volatile long lastIdleReset;
    protected final ConcurrentHashMap<CometTask, Object> activeTasks;
    protected final ConcurrentHashMap<CometHandler, SelectionKey> handlers;
    private final CometEvent eventInterrupt;
    private final CometEvent eventInitialize;
    private static final IllegalStateException ISE = new IllegalStateException("CometHandler cannot be null. This CometHandler was probably resumed and an invalid reference was made to it.");
    private static final IllegalStateException cometNotEnabled = new IllegalStateException("Make sure you have enabled Comet or make sure the Thread invoking that method is the same as the Servlet.service() Thread.");

    public CometContext(String topic, int continuationType) {
        this.topic = topic;
        this.continuationType = continuationType;
        this.attributes = new ConcurrentHashMap();
        this.handlers = new ConcurrentHashMap(16, 0.75f, 64);
        this.activeTasks = new ConcurrentHashMap(16, 0.75f, 64);
        this.eventInterrupt = new CometEvent(0, this);
        this.eventInitialize = new CometEvent(2, this);
    }

    public String getContextPath() {
        return this.getTopic();
    }

    public String getTopic() {
        return this.topic;
    }

    public void addAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public int addCometHandler(CometHandler handler, boolean alreadySuspended) {
        if (handler == null) {
            throw ISE;
        }
        if (!CometEngine.getEngine().isCometEnabled()) {
            throw cometNotEnabled;
        }
        CometTask cometTask = new CometTask();
        cometTask.setCometContext(this);
        cometTask.setCometHandler(handler);
        cometTask.setSuspended(alreadySuspended);
        CometEngine.updatedContexts.set(cometTask);
        return handler.hashCode();
    }

    public int addCometHandler(CometHandler handler) {
        return this.addCometHandler(handler, false);
    }

    public CometHandler getCometHandler(int hashCode) {
        for (CometHandler handler : this.handlers.keySet()) {
            if (handler.hashCode() != hashCode) continue;
            return handler;
        }
        return null;
    }

    public void recycle() {
        this.handlers.clear();
        this.attributes.clear();
        this.activeTasks.clear();
        this.topic = null;
    }

    protected void addActiveHandler(CometHandler handler, SelectionKey cometKey) {
        this.handlers.put(handler, cometKey);
    }

    protected void invokeCometHandler(CometEvent event, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw ISE;
        }
        event.setCometContext(this);
        if (cometHandler instanceof DefaultConcurrentCometHandler) {
            ((DefaultConcurrentCometHandler)cometHandler).EnQueueEvent(event);
        } else {
            cometHandler.onEvent(event);
        }
    }

    public boolean removeCometHandler(CometHandler handler) {
        return this.removeCometHandler(handler, true);
    }

    public boolean removeCometHandler(CometHandler handler, boolean resume) {
        SelectionKey key = this.handlers.remove(handler);
        if (key != null) {
            if (resume) {
                CometEngine.getEngine().flushPostExecute(((CometTask)((Object)key.attachment())).getAsyncProcessorTask());
            }
            return true;
        }
        return false;
    }

    public boolean removeCometHandler(int hashCode) {
        Iterator iterator = this.handlers.keySet().iterator();
        CometHandler handler = null;
        while (iterator.hasNext()) {
            handler = (CometHandler)iterator.next();
            if (handler.hashCode() != hashCode) continue;
            SelectionKey key = this.handlers.get(handler);
            if (key == null) {
                logger.warning(ALREADY_REMOVED);
                return false;
            }
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean resumeCometHandler(CometHandler handler) {
        return this.resumeCometHandler(handler, true);
    }

    protected boolean resumeCometHandler(CometHandler handler, boolean remove) {
        return this.cometSelector.cancelKey(this.handlers.get(handler), false, remove, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean interrupt(CometTask task, boolean removeCometHandler, boolean notifyInterrupt) {
        boolean status = true;
        try {
            if (removeCometHandler) {
                boolean bl = status = this.handlers.remove(task.getCometHandler()) != null;
                if (status && notifyInterrupt) {
                    task.getCometHandler().onInterrupt(this.eventInterrupt);
                }
                logger.finer(ALREADY_REMOVED);
            }
        }
        catch (Throwable ex) {
            status = false;
            logger.log(Level.FINE, "Unable to interrupt", ex);
        }
        finally {
            this.activeTasks.remove((Object)task);
            return status;
        }
    }

    public boolean isActive(CometHandler handler) {
        return this.handlers.containsKey(handler);
    }

    public void notify(E attachment) throws IOException {
        this.notify(attachment, 1);
    }

    public void notify(E attachment, int eventType, int cometHandlerID) throws IOException {
        this.notify(attachment, eventType, this.getCometHandler(cometHandlerID));
    }

    public void notify(E attachment, CometHandler cometHandler) throws IOException {
        this.notify(attachment, 1, cometHandler);
    }

    public void notify(E attachment, int eventType, CometHandler cometHandler) throws IOException {
        if (cometHandler == null) {
            throw ISE;
        }
        CometEvent<E> event = new CometEvent<E>(eventType, this);
        event.attach(attachment);
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, cometHandler);
        if (event.getType() == 3 || event.getType() == 0) {
            this.resumeCometHandler(cometHandler);
        } else {
            this.resetSuspendIdleTimeout();
        }
    }

    public void notify(E attachment, int eventType) throws IOException {
        CometEvent<E> event = new CometEvent<E>(eventType, this);
        event.attach(attachment);
        Iterator<CometHandler> iterator = this.handlers.keySet().iterator();
        this.notificationHandler.setBlockingNotification(this.blockingNotification);
        this.notificationHandler.notify(event, iterator);
        if (event.getType() == 3 || event.getType() == 0) {
            while (iterator.hasNext()) {
                this.resumeCometHandler(iterator.next());
            }
        } else {
            this.resetSuspendIdleTimeout();
        }
    }

    protected void initialize(CometHandler handler) throws IOException {
        handler.onInitialize(this.eventInitialize);
    }

    protected void resetSuspendIdleTimeout() {
        long timestamp;
        if (this.expirationDelay != -1L && (timestamp = System.currentTimeMillis()) - this.lastIdleReset >= 1000L) {
            this.lastIdleReset = timestamp;
            for (CometTask cometTask : this.activeTasks.keySet()) {
                cometTask.setExpireTime(timestamp);
            }
        }
    }

    public boolean registerAsyncRead(CometHandler handler) {
        return this.doAsyncRegister(handler, 1);
    }

    public boolean registerAsyncWrite(CometHandler handler) {
        return this.doAsyncRegister(handler, 4);
    }

    private boolean doAsyncRegister(CometHandler handler, int interest) {
        SelectionKey cometKey = null;
        if (handler != null) {
            cometKey = this.handlers.get(handler);
        }
        if (handler == null || cometKey == null) {
            throw ISE;
        }
        CometTask cometTask = (CometTask)((Object)cometKey.attachment());
        if (cometTask != null) {
            cometKey.interestOps(cometKey.interestOps() | interest);
            if (interest == 1) {
                cometTask.setAsyncReadSupported(true);
            }
            cometTask.setComethandlerisAsyncregistered(true);
            return true;
        }
        throw ISE;
    }

    protected void setCometSelector(CometSelector cometSelector) {
        this.cometSelector = cometSelector;
    }

    public String toString() {
        return this.topic;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    public Set<CometHandler> getCometHandlers() {
        return this.handlers.keySet();
    }

    protected void addActiveCometTask(CometTask cometTask) {
        this.activeTasks.put(cometTask, Boolean.TRUE);
    }

    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    protected Set<CometTask> getActiveTasks() {
        return this.activeTasks.keySet();
    }
}

