/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometTask;
import com.sun.grizzly.comet.DefaultNotificationHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.LinkedTransferQueue;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometEngine {
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    public static final int AFTER_SERVLET_PROCESSING = 1;
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    private static final Logger logger = SelectorThread.logger();
    private static final IllegalStateException ISE = new IllegalStateException("Invalid state");
    protected ExecutorService threadPool;
    private static final CometEngine cometEngine = new CometEngine();
    protected final ConcurrentHashMap<String, CometContext> activeContexts;
    protected final CometSelector cometSelector = new CometSelector(this);
    protected final LinkedTransferQueue<CometContext> cometContextCache;
    private static volatile boolean isCometSupported;
    protected static final ThreadLocal<CometTask> updatedContexts;
    private static final SelectionKey dumykey;

    protected CometEngine() {
        try {
            this.cometSelector.start();
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Unable to start CometSelector", ex);
        }
        this.cometContextCache = new LinkedTransferQueue();
        this.activeContexts = new ConcurrentHashMap(16, 0.75f, 64);
        this.threadPool = new ThreadPoolExecutor(8, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            public Thread newThread(Runnable r) {
                return new Thread(r, "CometWorker-" + this.counter.incrementAndGet());
            }
        });
    }

    protected boolean isCometEnabled() {
        return isCometSupported;
    }

    public static CometEngine getEngine() {
        return cometEngine;
    }

    public void setThreadPool(ExecutorService threadPool) {
        if (threadPool != null) {
            this.threadPool.shutdownNow();
            this.threadPool = threadPool;
        }
    }

    public CometContext unregister(String topic) {
        CometContext cometContext = this.activeContexts.remove(topic);
        if (cometContext != null) {
            try {
                cometContext.notify(cometContext, 3);
            }
            catch (IOException ex) {
                // empty catch block
            }
            Set<CometTask> tasks = cometContext.getActiveTasks();
            for (CometTask cometTask : tasks) {
                this.flushResponse(cometTask.getAsyncProcessorTask());
            }
            cometContext.recycle();
            this.cometContextCache.offer((Object)cometContext);
        }
        return cometContext;
    }

    public CometContext register(String topic) {
        return this.register(topic, 1);
    }

    public CometContext register(String topic, int type) {
        return this.register(topic, type, DefaultNotificationHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CometContext register(String topic, int type, Class<? extends NotificationHandler> notificationClass) {
        CometContext cometContext = this.activeContexts.get(topic);
        if (cometContext == null) {
            ConcurrentHashMap<String, CometContext> concurrentHashMap = this.activeContexts;
            synchronized (concurrentHashMap) {
                cometContext = this.activeContexts.get(topic);
                if (cometContext == null) {
                    cometContext = (CometContext)this.cometContextCache.poll();
                    if (cometContext != null) {
                        cometContext.topic = topic;
                    }
                    if (cometContext == null) {
                        cometContext = new CometContext(topic, type);
                        NotificationHandler notificationHandler = null;
                        try {
                            notificationHandler = notificationClass.newInstance();
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "Invalid NotificationHandler class : " + notificationClass.getName() + " Using default.", t);
                            notificationHandler = new DefaultNotificationHandler();
                        }
                        cometContext.setCometSelector(this.cometSelector);
                        cometContext.setNotificationHandler(notificationHandler);
                        if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                            ((DefaultNotificationHandler)notificationHandler).setThreadPool(this.threadPool);
                        }
                    }
                    this.activeContexts.put(topic, cometContext);
                }
            }
        }
        return cometContext;
    }

    protected boolean handle(AsyncProcessorTask apt) throws IOException {
        String topic;
        if (!isCometSupported) {
            isCometSupported = true;
        }
        CometContext cometContext = (topic = apt.getAsyncExecutor().getProcessorTask().getRequestURI()) == null ? null : this.activeContexts.get(topic);
        int continuationType = cometContext == null ? 1 : cometContext.continuationType;
        this.executeServlet(continuationType, apt);
        CometTask cometTask = updatedContexts.get();
        if (cometTask != null) {
            updatedContexts.set(null);
            if (cometTask.isSuspended()) {
                cometTask.setSuspended(false);
                cometTask.getCometContext().addActiveHandler(cometTask.getCometHandler(), dumykey);
                return false;
            }
            SelectionKey key = apt.getAsyncExecutor().getProcessorTask().getSelectionKey();
            key.attach(null);
            cometTask.getCometContext().initialize(cometTask.getCometHandler());
            cometTask.setAsyncProcessorTask(apt);
            cometTask.setSelectionKey(key);
            cometTask.setCometSelector(this.cometSelector);
            cometTask.setSelectorThread(apt.getSelectorThread());
            cometTask.setThreadPool(apt.getThreadPool());
            this.cometSelector.registerKey(cometTask);
            return true;
        }
        return false;
    }

    public CometContext getCometContext(String topic) {
        return this.activeContexts.get(topic);
    }

    protected void flushPostExecute(AsyncProcessorTask apt) {
        if (apt != null && apt.getStage() == 2) {
            this.flushResponse(apt);
        }
    }

    protected void flushResponse(AsyncProcessorTask apt) {
        apt.setStage(2);
        try {
            apt.doTask();
        }
        catch (IllegalStateException ex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Resuming Response failed", ex);
            }
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Resuming  failed", ex);
        }
    }

    private void executeServlet(int continuationType, AsyncProcessorTask apt) {
        try {
            switch (continuationType) {
                case 0: {
                    apt.setStage(0);
                    break;
                }
                case 1: {
                    apt.getAsyncExecutor().getProcessorTask().invokeAdapter();
                    return;
                }
                case 2: {
                    apt.setStage(2);
                    apt.doTask();
                    break;
                }
                default: {
                    throw ISE;
                }
            }
            if (apt.getStage() != 2) {
                apt.doTask();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "executeServlet", ex);
        }
    }

    public static final Logger logger() {
        return logger;
    }

    static {
        updatedContexts = new ThreadLocal();
        dumykey = new SelectionKey(){

            public SelectableChannel channel() {
                throw ISE;
            }

            public int interestOps() {
                throw ISE;
            }

            public SelectionKey interestOps(int ops) {
                throw ISE;
            }

            public int readyOps() {
                throw ISE;
            }

            public Selector selector() {
                throw ISE;
            }

            public boolean isValid() {
                return true;
            }

            public void cancel() {
            }
        };
    }
}

