/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometReader;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometWriter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskBase;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class CometTask
extends TaskBase {
    protected OP_EVENT upcoming_op = OP_EVENT.READ;
    private CometContext cometContext;
    private CometSelector cometSelector;
    private long expireTime;
    private volatile boolean comethandlerisAsyncregistered;
    private InputReader cometInputStream;
    private SelectionKey cometKey;
    private AsyncProcessorTask asyncProcessorTask;
    private CometEvent event;
    private CometHandler cometHandler;
    private CometWriter writer;
    private CometReader reader;
    private boolean asyncReadSupported;
    private boolean isSuspended = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        if (!this.cometContext.isActive(this.cometHandler)) {
            return;
        }
        ByteBuffer byteBuffer = null;
        boolean connectionClosed = false;
        boolean clearBuffer = true;
        try {
            if (this.cometInputStream == null) {
                this.cometInputStream = new InputReader();
            }
            this.cometInputStream.setSelectionKey(this.cometKey);
            byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocate(this.selectorThread.getBufferSize());
                ((WorkerThread)Thread.currentThread()).setByteBuffer(byteBuffer);
            } else {
                byteBuffer.clear();
            }
            this.cometInputStream.setByteBuffer(byteBuffer);
            SocketChannel socketChannel = (SocketChannel)this.cometKey.channel();
            if (this.upcoming_op == OP_EVENT.READ) {
                int nRead = socketChannel.read(byteBuffer);
                if (nRead == -1) {
                    connectionClosed = true;
                } else if (!this.asyncReadSupported) {
                    this.key.attach(Long.MIN_VALUE);
                    if (!this.cometContext.isActive(this.cometHandler)) {
                        return;
                    }
                    nRead = socketChannel.read(byteBuffer);
                    if (nRead == -1) {
                        connectionClosed = true;
                        return;
                    }
                    this.cometContext.resumeCometHandler(this.cometHandler, false);
                    clearBuffer = false;
                    Controller controller = this.getSelectorThread().getController();
                    ProtocolChain protocolChain = controller.getProtocolChainInstanceHandler().poll();
                    NIOContext ctx = (NIOContext)controller.pollContext(this.key);
                    ctx.setController(controller);
                    ctx.setSelectionKey(this.key);
                    ctx.setProtocolChain(protocolChain);
                    ctx.setProtocol(Controller.Protocol.TCP);
                    protocolChain.execute((Context)ctx);
                } else {
                    byteBuffer.flip();
                    this.reader = new CometReader();
                    this.reader.setNRead(nRead);
                    this.reader.setByteBuffer(byteBuffer);
                    if (this.event == null) {
                        this.event = new CometEvent();
                    }
                    this.event.type = 4;
                    this.event.attach(this.reader);
                    this.cometContext.invokeCometHandler(this.event, this.cometHandler);
                    this.reader.setByteBuffer(null);
                    this.reader.setReady(false);
                }
            } else if (this.upcoming_op == OP_EVENT.WRITE) {
                if (this.event == null) {
                    this.event = new CometEvent();
                }
                this.event.type = 5;
                this.writer = new CometWriter();
                this.writer.setChannel(socketChannel);
                this.event.attach(this.writer);
                this.cometContext.invokeCometHandler(this.event, this.cometHandler);
                this.writer.setReady(false);
            }
        }
        catch (IOException ex) {
            connectionClosed = true;
            if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                SelectorThread.logger().log(Level.FINEST, "Comet exception", ex);
            }
        }
        catch (Throwable t) {
            connectionClosed = true;
            SelectorThread.logger().log(Level.SEVERE, "Comet exception", t);
        }
        finally {
            if (connectionClosed) {
                this.cometSelector.cancelKey(this.cometKey, true, true, true);
            }
            if (clearBuffer && byteBuffer != null) {
                byteBuffer.clear();
            }
            this.asyncReadSupported = false;
        }
    }

    public void setComethandlerisAsyncregistered(boolean comethandlerisAsyncregistered) {
        this.comethandlerisAsyncregistered = comethandlerisAsyncregistered;
    }

    public boolean isComethandlerisAsyncregistered() {
        return this.comethandlerisAsyncregistered;
    }

    public boolean cometHandlerNotResumed() {
        return this.cometContext.isActive(this.cometHandler);
    }

    public CometContext getCometContext() {
        return this.cometContext;
    }

    public void setCometContext(CometContext cometContext) {
        this.cometContext = cometContext;
    }

    public void recycle() {
        this.isSuspended = false;
        this.key = null;
        this.cometContext = null;
        this.asyncReadSupported = false;
        if (this.cometInputStream != null) {
            this.cometInputStream.recycle();
        }
    }

    public CometSelector getCometSelector() {
        return this.cometSelector;
    }

    public void setCometSelector(CometSelector cometSelector) {
        this.cometSelector = cometSelector;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public SelectionKey getCometKey() {
        return this.cometKey;
    }

    public void setCometKey(SelectionKey cometKey) {
        this.cometKey = cometKey;
    }

    public boolean isAsyncReadSupported() {
        return this.asyncReadSupported;
    }

    public void setAsyncReadSupported(boolean asyncReadSupported) {
        this.asyncReadSupported = asyncReadSupported;
    }

    protected boolean hasExpired(long timestamp) {
        long expdelay = this.cometContext.getExpirationDelay();
        return expdelay != -1L && timestamp - this.expireTime >= expdelay;
    }

    public AsyncProcessorTask getAsyncProcessorTask() {
        return this.asyncProcessorTask;
    }

    public void setAsyncProcessorTask(AsyncProcessorTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public CometHandler getCometHandler() {
        return this.cometHandler;
    }

    public void setCometHandler(CometHandler cometHandler) {
        this.cometHandler = cometHandler;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OP_EVENT {
        READ,
        WRITE;

    }
}

