/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Controller;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.NotificationHandler;
import com.sun.grizzly.comet.concurrent.DefaultConcurrentCometHandler;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNotificationHandler
implements NotificationHandler {
    private static final Logger logger = Controller.logger();
    private static final IllegalStateException ISEempty = new IllegalStateException();
    protected ExecutorService threadPool;
    protected boolean blockingNotification;
    private boolean spreadNotifyToManyToThreads = true;

    protected void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public boolean isBlockingNotification() {
        return this.blockingNotification;
    }

    @Override
    public void setBlockingNotification(boolean blockingNotification) {
        this.blockingNotification = blockingNotification;
    }

    @Override
    public void notify(final CometEvent cometEvent, final Iterator<CometHandler> iteratorHandlers) throws IOException {
        if (!this.spreadNotifyToManyToThreads && !this.blockingNotification && this.threadPool != null) {
            this.threadPool.execute(new Runnable(){

                public void run() {
                    while (iteratorHandlers.hasNext()) {
                        DefaultNotificationHandler.this.notify0(cometEvent, (CometHandler)iteratorHandlers.next());
                    }
                }
            });
        } else {
            while (iteratorHandlers.hasNext()) {
                this.notify(cometEvent, iteratorHandlers.next());
            }
        }
    }

    @Override
    public void notify(final CometEvent cometEvent, final CometHandler cometHandler) throws IOException {
        if (this.blockingNotification || this.threadPool == null) {
            this.notify0(cometEvent, cometHandler);
        } else {
            this.threadPool.execute(new Runnable(){

                public void run() {
                    DefaultNotificationHandler.this.notify0(cometEvent, cometHandler);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify0(CometEvent cometEvent, CometHandler cometHandler) {
        try {
            switch (cometEvent.getType()) {
                case 0: {
                    if (cometHandler instanceof DefaultConcurrentCometHandler) {
                        ((DefaultConcurrentCometHandler)cometHandler).shutdownQueue();
                        cometHandler.onInterrupt(cometEvent);
                        break;
                    }
                    CometHandler cometHandler2 = cometHandler;
                    synchronized (cometHandler2) {
                        cometHandler.onInterrupt(cometEvent);
                        break;
                    }
                }
                case 1: 
                case 4: 
                case 5: {
                    if (cometHandler instanceof DefaultConcurrentCometHandler) {
                        ((DefaultConcurrentCometHandler)cometHandler).EnQueueEvent(cometEvent);
                        break;
                    }
                    if (cometEvent.getCometContext().isActive(cometHandler)) {
                        CometHandler cometHandler3 = cometHandler;
                        synchronized (cometHandler3) {
                            cometHandler.onEvent(cometEvent);
                        }
                    }
                    break;
                }
                case 2: {
                    cometHandler.onInitialize(cometEvent);
                    break;
                }
                case 3: {
                    if (cometHandler instanceof DefaultConcurrentCometHandler) {
                        ((DefaultConcurrentCometHandler)cometHandler).shutdownQueue();
                        cometHandler.onTerminate(cometEvent);
                        break;
                    }
                    CometHandler cometHandler4 = cometHandler;
                    synchronized (cometHandler4) {
                        cometHandler.onTerminate(cometEvent);
                        break;
                    }
                }
                default: {
                    throw ISEempty;
                }
            }
        }
        catch (Throwable ex) {
            try {
                cometEvent.getCometContext().resumeCometHandler(cometHandler, true);
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Resume phase failed: ", t);
            }
            logger.log(Level.FINE, "Notification failed: ", ex);
        }
    }
}

