/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet.concurrent;

import com.sun.grizzly.Controller;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultConcurrentCometHandler<E>
implements CometHandler<E> {
    protected static final Logger logger = Controller.logger();
    protected volatile boolean shuttingdown;
    private final int messageQueueLimit;
    private int queuesize;
    private boolean isreadyforwork = true;
    protected final LinkedList<CometEvent> messageQueue = new LinkedList();
    protected E attachment;

    public DefaultConcurrentCometHandler() {
        this(100);
    }

    public DefaultConcurrentCometHandler(int messageQueueLimit) {
        this.messageQueueLimit = messageQueueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EnQueueEvent(CometEvent event) {
        if (this.shuttingdown) {
            return;
        }
        LinkedList<CometEvent> linkedList = this.messageQueue;
        synchronized (linkedList) {
            if (!this.isreadyforwork) {
                if (!this.shuttingdown && this.queuesize < this.messageQueueLimit) {
                    this.messageQueue.add(event);
                    ++this.queuesize;
                }
                return;
            }
            this.isreadyforwork = false;
        }
        boolean queuefull = false;
        while (!this.shuttingdown) {
            if (!event.getCometContext().isActive(this)) {
                this.shuttingdown = true;
                return;
            }
            try {
                this.onEvent(event);
            }
            catch (Throwable ex) {
                this.shuttingdown = true;
                event.getCometContext().resumeCometHandler(this);
                return;
            }
            LinkedList<CometEvent> linkedList2 = this.messageQueue;
            synchronized (linkedList2) {
                if (this.queuesize == this.messageQueueLimit) {
                    queuefull = true;
                } else {
                    if (this.queuesize == 0) {
                        this.isreadyforwork = true;
                        return;
                    }
                    event = this.messageQueue.poll();
                    --this.queuesize;
                }
            }
            if (!queuefull) continue;
            this.shuttingdown = true;
            this.onQueueFull(event);
        }
    }

    public void onQueueFull(CometEvent event) {
        event.getCometContext().resumeCometHandler(this);
    }

    public void shutdownQueue() {
        this.shuttingdown = true;
    }

    public E attachment() {
        return this.attachment;
    }

    @Override
    public void attach(E attachment) {
        this.attachment = attachment;
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.terminate();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.terminate();
    }

    protected void terminate() {
        if (this.attachment() instanceof Closeable) {
            try {
                ((Closeable)this.attachment()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

