/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.AbstractMain;
import com.sun.enterprise.glassfish.bootstrap.ProxyModule;
import com.sun.enterprise.glassfish.bootstrap.ProxyModuleDefinition;
import com.sun.enterprise.glassfish.bootstrap.Rejar;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.impl.HK2Factory;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainStatic
extends AbstractMain {
    private final Logger logger;
    private String[] args;
    private File out;

    public ASMainStatic(Logger logger, String[] args) {
        this.logger = logger;
        this.args = args;
    }

    public void run() {
        try {
            this.start(this.args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start(String[] args) throws BootException {
        File modulesDir = this.findBootstrapFile().getParentFile();
        File glassfishDir = modulesDir.getParentFile();
        final StartupContext startupContext = new StartupContext(modulesDir, args);
        ASMainHelper helper = new ASMainHelper(Logger.getAnonymousLogger());
        helper.parseAsEnv(glassfishDir);
        File domainDir = helper.getDomainRoot(startupContext);
        helper.verifyDomainRoot(domainDir);
        System.setProperty("com.sun.aas.installRoot", glassfishDir.getAbsolutePath());
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        URI installRootURI = new File(installRoot).toURI();
        System.setProperty("com.sun.aas.installRootURI", installRootURI.toString());
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        URI instanceRootURI = new File(instanceRoot).toURI();
        System.setProperty("com.sun.aas.instanceRootURI", instanceRootURI.toString());
        ClassLoader singleClassLoader = null;
        HK2Factory.initialize();
        final File cacheDir = System.getProperty("glassfish.static.cache.dir") != null ? new File(System.getProperty("glassfish.static.cache.dir"), "static-cache/gf/") : new File(domainDir, "static-cache/gf/");
        this.out = new File(cacheDir, "glassfish.jar");
        final long lastModified = this.getLastModified(this.bootstrapFile.getParentFile(), 0L);
        Thread cacheThread = null;
        if (this.isCacheOutdated(lastModified, cacheDir)) {
            this.logger.info("Cache not present, will revert to less efficient algorithm");
            cacheThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ASMainStatic.this.flushAndCreate(cacheDir, lastModified);
                    }
                    catch (IOException e) {
                        ASMainStatic.this.getLogger().log(Level.SEVERE, "Failed setting up the cache, aborting", e);
                    }
                }
            });
            try {
                singleClassLoader = this.createTmpClassLoader(this.bootstrapFile.getParentFile());
            }
            catch (Exception e) {
                throw new BootException(e);
            }
        }
        try {
            singleClassLoader = this.createClassLoader(cacheDir);
        }
        catch (Exception e) {
            throw new BootException(e);
        }
        if (singleClassLoader == null) {
            throw new BootException("Could not create single class loader from the cache");
        }
        final Module[] proxyMod = new Module[1];
        final ModulesRegistryImpl modulesRegistry = new ModulesRegistryImpl(null){

            @Override
            public Module find(Class clazz) {
                Module m = super.find(clazz);
                if (m == null) {
                    return proxyMod[0];
                }
                return m;
            }

            @Override
            public Collection<Module> getModules(String moduleName) {
                return this.getModules();
            }

            @Override
            public Collection<Module> getModules() {
                ArrayList<Module> list = new ArrayList<Module>();
                list.add(proxyMod[0]);
                return list;
            }

            @Override
            public Module makeModuleFor(String name, String version) throws ResolveError {
                return proxyMod[0];
            }

            @Override
            public void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
                Holder<ClassLoader> holder = new Holder<ClassLoader>(){

                    @Override
                    public ClassLoader get() {
                        return proxyMod[0].getClassLoader();
                    }
                };
                for (ModuleMetadata.InhabitantsDescriptor d : proxyMod[0].getMetadata().getHabitats(name)) {
                    inhabitantsParser.parse(d.createScanner(), holder);
                }
            }
        };
        modulesRegistry.setParentClassLoader(singleClassLoader);
        ProxyModuleDefinition moduleDef = null;
        try {
            moduleDef = new ProxyModuleDefinition(singleClassLoader);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Cannot load single module from cache", e);
            throw new BootException(e);
        }
        proxyMod[0] = new ProxyModule(modulesRegistry, moduleDef, singleClassLoader);
        modulesRegistry.add(moduleDef);
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                Main main = new Main(){

                    protected Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
                        Habitat habitat = registry.newHabitat();
                        habitat.add(new ExistingSingletonInhabitant<StartupContext>(context));
                        habitat.add(new ExistingSingletonInhabitant<ModulesRegistry>(ModulesRegistry.class, registry));
                        habitat.add(new ExistingSingletonInhabitant<Logger>(Logger.class, ASMainStatic.this.logger));
                        registry.createHabitat("default", this.createInhabitantsParser(habitat));
                        return habitat;
                    }
                };
                try {
                    main.launch(modulesRegistry, startupContext);
                }
                catch (BootException e) {
                    ASMainStatic.this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }, "Static Framework Launcher");
        launcherThread.setContextClassLoader(singleClassLoader);
        launcherThread.setDaemon(true);
        launcherThread.start();
        try {
            launcherThread.join();
        }
        catch (InterruptedException e) {
            this.logger.warning("main thread interrupted");
        }
        this.logger.fine("Framework successfully started");
        if (cacheThread != null) {
            this.logger.info("Started cache creation");
            cacheThread.start();
            try {
                cacheThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.logger.info("Finished cache creation");
        }
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }

    @Override
    long getSettingsLastModification() {
        return 0L;
    }

    @Override
    boolean createCache(File cacheDir) throws IOException {
        cacheDir.mkdirs();
        Rejar rejar = new Rejar();
        rejar.rejar(this.out, this.bootstrapFile.getParentFile());
        return true;
    }

    public ClassLoader createClassLoader(File cacheDir) throws Exception {
        if (this.out != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(this.out.toURI().toURL());
            this.findDerbyClient(urls);
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        }
        return null;
    }

    public ClassLoader createTmpClassLoader(File moduleDir) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.insertURLs(moduleDir, urls);
        this.findDerbyClient(urls);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
    }

    private void insertURLs(File directory, List<URL> result) throws Exception {
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                result.add(file.toURI().toURL());
                continue;
            }
            this.insertURLs(file, result);
        }
    }

    private void findDerbyClient(List<URL> urls) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        urls.add(new File(derbyLib, "derby.jar").toURI().toURL());
        urls.add(new File(derbyLib, "derbyclient.jar").toURI().toURL());
    }
}

