/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.jsftemplating.component.TemplateInputComponentBase;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamerPhaseListener;
import com.sun.mojarra.scales.component.Links;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class DateSelector
extends TemplateInputComponentBase {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.DateSelector";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.DateSelector";
    private Object[] _state = null;
    private Boolean hideBlankWeeks = false;
    private String locale = null;
    private Boolean multiSelect = false;
    private String navigator = "true";
    private String onChange = null;
    private Boolean showWeekdays = true;
    private Boolean showWeekFooter = false;
    private Boolean showWeekHeader = false;
    private Integer startWeekday = 0;
    private Boolean showMenus = false;
    private String minDate = null;
    private String maxDate = null;
    private Boolean popup = Boolean.TRUE;
    private Date value = null;
    private String format;
    private boolean enableManualInput = false;

    public DateSelector() {
        this.setRendererType("com.sun.mojarra.scales.DateSelector");
        this.setLayoutDefinitionKey("/templates/dateselector.xhtml");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/assets/skins/sam/skin.css"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/calendar/calendar-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/scales/dateselector_helper.js"));
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.DateSelector";
    }

    public Boolean getHideBlankWeeks() {
        return (Boolean)this.getPropertyValue(this.hideBlankWeeks, "hideBlankWeeks", Boolean.FALSE);
    }

    public String getLocale() {
        return (String)this.getPropertyValue(this.locale, "language", "en_US");
    }

    public Boolean getMultiSelect() {
        return (Boolean)this.getPropertyValue(this.multiSelect, "multiSelect", Boolean.FALSE);
    }

    public String getNavigator() {
        return (String)this.getPropertyValue(this.navigator, "navigator", "true");
    }

    public String getOnChange() {
        return (String)this.getPropertyValue(this.onChange, "onChange", null);
    }

    public Boolean getPopup() {
        return (Boolean)this.getPropertyValue(this.popup, "popup", Boolean.TRUE);
    }

    public Boolean getShowWeekdays() {
        return (Boolean)this.getPropertyValue(this.showWeekdays, "showWeekdays", Boolean.TRUE);
    }

    public Boolean getShowWeekFooter() {
        return (Boolean)this.getPropertyValue(this.showWeekFooter, "showWeekFooter", Boolean.FALSE);
    }

    public Boolean getShowWeekHeader() {
        return (Boolean)this.getPropertyValue(this.showWeekHeader, "showWeekHeader", Boolean.FALSE);
    }

    public Integer getStartWeekday() {
        return (Integer)this.getPropertyValue(this.startWeekday, "startWeekday", 0);
    }

    public String getMinDate() {
        return (String)this.getPropertyValue(this.minDate, "minDate", null);
    }

    public String getMaxDate() {
        return (String)this.getPropertyValue(this.maxDate, "maxDate", null);
    }

    public Boolean getShowMenus() {
        return (Boolean)this.getPropertyValue(this.showMenus, "showMenus", Boolean.FALSE);
    }

    public String getFormat() {
        return (String)this.getPropertyValue(this.format, "format", "yyyy/MM/dd");
    }

    public boolean getEnableManualInput() {
        return (Boolean)this.getPropertyValue(this.enableManualInput, "enableManualInput", false);
    }

    public Object getValue() {
        return this.getPropertyValue(this.value, "value", null);
    }

    public void setHideBlankWeeks(Boolean hideBlankWeeks) {
        this.hideBlankWeeks = hideBlankWeeks;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setNavigator(String navigator) {
        this.navigator = navigator;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public void setShowWeekdays(Boolean showWeekdays) {
        this.showWeekdays = showWeekdays;
    }

    public void setShowWeekFooter(Boolean showWeekFooter) {
        this.showWeekFooter = showWeekFooter;
    }

    public void setShowWeekHeader(Boolean showWeekHeader) {
        this.showWeekHeader = showWeekHeader;
    }

    public void setStartWeekday(Integer startWeekday) {
        this.startWeekday = startWeekday;
    }

    public void setMinDate(String minDate) {
        this.minDate = minDate;
    }

    public void setMaxDate(String maxDate) {
        this.maxDate = maxDate;
    }

    public void setPopup(Boolean popup) {
        this.popup = popup;
    }

    public void setShowMenus(Boolean showMenus) {
        this.showMenus = showMenus;
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.value = (Date)value;
    }

    public void setFormat(String format) {
        new SimpleDateFormat(format);
        this.format = format;
    }

    public void setEnableManualInput(boolean enableManualInput) {
        this.enableManualInput = enableManualInput;
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public void decode(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(facesContext);
        try {
            Date date = null;
            String string_submit_val = (String)requestMap.get(clientId);
            if (string_submit_val != null) {
                String format = this.getFormat();
                SimpleDateFormat df = new SimpleDateFormat(format);
                date = df.parse(string_submit_val);
            }
            this.setSubmittedValue(date);
        }
        catch (ParseException ex) {
            facesContext.addMessage(this.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, ex.getMessage(), null));
            Logger.getLogger(DateSelector.class.getName()).severe(ex.getMessage());
        }
    }

    public void restoreState(FacesContext _context, Object _state) {
        this._state = (Object[])_state;
        super.restoreState(_context, this._state[0]);
        this.multiSelect = (Boolean)this._state[1];
        this.showWeekdays = (Boolean)this._state[2];
        this.startWeekday = (Integer)this._state[3];
        this.showWeekHeader = (Boolean)this._state[4];
        this.showWeekFooter = (Boolean)this._state[5];
        this.hideBlankWeeks = (Boolean)this._state[6];
        this.onChange = (String)this._state[7];
        this.locale = (String)this._state[8];
        this.minDate = (String)this._state[9];
        this.maxDate = (String)this._state[10];
        this.showMenus = (Boolean)this._state[11];
        this.navigator = (String)this._state[12];
        this.popup = (Boolean)this._state[13];
        this.format = (String)this._state[14];
        this.enableManualInput = (Boolean)this._state[15];
    }

    public Object saveState(FacesContext _context) {
        if (this._state == null) {
            this._state = new Object[16];
        }
        this._state[0] = super.saveState(_context);
        this._state[1] = this.multiSelect;
        this._state[2] = this.showWeekdays;
        this._state[3] = this.startWeekday;
        this._state[4] = this.showWeekHeader;
        this._state[5] = this.showWeekFooter;
        this._state[6] = this.hideBlankWeeks;
        this._state[7] = this.onChange;
        this._state[8] = this.locale;
        this._state[9] = this.minDate;
        this._state[10] = this.maxDate;
        this._state[11] = this.showMenus;
        this._state[12] = this.navigator;
        this._state[13] = this.popup;
        this._state[14] = this.format;
        this._state[15] = this.enableManualInput;
        return this._state;
    }

    public static void calculateFieldPositions(HandlerContext hc) {
        DateSelector ds = (DateSelector)((Object)hc.getInputValue("comp"));
        String format = ds.getFormat().toLowerCase();
        String[] parts = format.split("/");
        if (parts.length == 1) {
            parts = format.split("-");
        }
        hc.setOutputValue("dayPosition", (Object)2);
        hc.setOutputValue("monthPosition", (Object)1);
        hc.setOutputValue("yearPosition", (Object)3);
        for (int i = 0; i < parts.length; ++i) {
            String paramName = "dayPosition";
            if (parts[i].startsWith("m")) {
                paramName = "monthPosition";
            } else if (parts[i].startsWith("y")) {
                paramName = "yearPosition";
            }
            hc.setOutputValue(paramName, (Object)(i + 1));
        }
    }

    public static void configureNavigator(HandlerContext hc) {
        DateSelector ds = (DateSelector)((Object)hc.getInputValue("comp"));
        ResourceBundle bundle = (ResourceBundle)hc.getInputValue("bundle");
        if ("true".equalsIgnoreCase(ds.getNavigator())) {
            String navConfig = "{strings: {month:\"" + bundle.getString("navigator_month") + "\"," + "year:\"" + bundle.getString("navigator_year") + "\"," + "submit: \"" + bundle.getString("navigator_submit") + "\"," + "cancel: \"" + bundle.getString("navigator_cancel") + "\"," + "invalidYear: \"" + bundle.getString("navigator_invalid_year") + "\"}," + "monthFormat: " + bundle.getString("navigator_month_format") + "," + "initialFocus: \"" + bundle.getString("navigator_initial_focus") + "\"}";
            hc.setOutputValue("navigator", (Object)navConfig);
        } else {
            hc.setOutputValue("navigator", (Object)ds.getNavigator());
        }
    }

    public static void prepareDateSelector(HandlerContext hc) {
        DateSelector ds = (DateSelector)((Object)hc.getInputValue("comp"));
        DateSelector.calculateFieldPositions(hc);
        DateSelector.configureNavigator(hc);
    }
}

