/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;

public class ScalesUtil {
    public static final String STATIC_RESOURCE_IDENTIFIER = "/scales_static_resource";
    private static String[] booleanPassthruAttributes = new String[]{"disabled", "readonly", "ismap"};
    private static final String INVOCATION_PATH = "com.sun.mojarra.scales.INVOCATION_PATH";
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width"};

    private ScalesUtil() {
    }

    private static boolean componentIsDisabledOrReadonly(UIComponent component) {
        Object disabledOrReadonly = null;
        boolean result = false;
        Object v = component.getAttributes().get("disabled");
        disabledOrReadonly = v;
        if (null != v) {
            result = disabledOrReadonly instanceof String ? ((String)disabledOrReadonly).equalsIgnoreCase("true") : disabledOrReadonly.equals(Boolean.TRUE);
        }
        if (!result && null != (disabledOrReadonly = component.getAttributes().get("readonly"))) {
            result = disabledOrReadonly instanceof String ? ((String)disabledOrReadonly).equalsIgnoreCase("true") : disabledOrReadonly.equals(Boolean.TRUE);
        }
        return result;
    }

    public static String getFacesMapping(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("The FacesContext was null.");
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            mapping = ScalesUtil.getMappingForRequest(servletPath, pathInfo);
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        return mapping;
    }

    public static ValueExpression createValueExpression(String valueRef, Class type) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ELContext elc = fc.getELContext();
        return fc.getApplication().getExpressionFactory().createValueExpression(elc, valueRef, Object.class);
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        ScalesUtil.renderPassThruAttributes(writer, component, null);
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        int i = 0;
        int len = passthruAttributes.length;
        int jLen = null != excludes ? excludes.length : 0;
        Object value = null;
        boolean skip = false;
        for (i = 0; i < len; ++i) {
            skip = false;
            if (null != excludes) {
                for (int j = 0; j < jLen; ++j) {
                    if (null == excludes[j] || !excludes[j].equals(passthruAttributes[i])) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || (value = (Object)component.getAttributes().get(passthruAttributes[i])) == null || !ScalesUtil.shouldRenderAttribute(value)) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.writeAttribute(passthruAttributes[i], value, passthruAttributes[i]);
        }
    }

    protected static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    protected static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }
}

