/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.pool;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.pool.DynamicPoolConfig;
import com.sun.grizzly.pool.Messages;
import com.sun.grizzly.pool.PoolAdapter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicPool<T> {
    public static final long DEFAULT_TIMEOUT = 360L;
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private final boolean asyncEnabled;
    private final int numberOfObjects;
    private ExecutorService objectGenerator = Executors.newCachedThreadPool();
    private final int maxGeneratingObjects;
    private AtomicInteger maximumIdleObjects = new AtomicInteger(1);
    private volatile int currentlyActiveObjects = 0;
    private volatile int currentlyGeneratingObjects = 0;
    private final int hardMaxActiveObjects;
    private final int hardMinActiveObjects;
    private AtomicInteger downTicks = new AtomicInteger(0);
    private AtomicInteger queueTicks = new AtomicInteger(0);
    private AtomicInteger newTicks = new AtomicInteger(0);
    private AtomicInteger downThreashold = new AtomicInteger(10);
    private final int queueThreashold;
    private AtomicInteger newThreashold = new AtomicInteger(10);
    private volatile boolean createdLast = true;
    private AtomicInteger successfulRequests = new AtomicInteger(0);
    private AtomicInteger successThreashold = new AtomicInteger(3000);
    private final double successGrowthPercentage = 1.25;
    private final double failureGrowthPercentage = 0.8;
    private final long baseTime;
    private final boolean dynamic;
    private final boolean validate;
    private final int requestTimeout = 50;
    private final boolean fineLog = SelectorThread.logger().isLoggable(Level.FINE);
    private PoolAdapter<T> objectLib;

    public DynamicPool(PoolAdapter<T> type, DynamicPoolConfig config) {
        this.objectLib = type;
        this.numberOfObjects = config.getNumberOfObjects();
        this.maxGeneratingObjects = config.getMaxGeneratingObjects();
        this.hardMaxActiveObjects = config.getHardMaxActiveObjects();
        this.hardMinActiveObjects = config.getHardMinActiveObjects();
        this.maximumIdleObjects.set(this.numberOfObjects);
        this.downThreashold.set(config.getDownThreashold());
        this.queueThreashold = config.getQueueThreashold();
        this.newThreashold.set(config.getNewThreashold());
        this.dynamic = config.isDynamic();
        this.asyncEnabled = config.isAsyncEnabled();
        this.validate = config.shouldValidate();
        this.baseTime = System.currentTimeMillis();
        this.logDynamicStatus();
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public boolean getValidation() {
        return this.validate;
    }

    public T borrowObject() {
        long time = System.currentTimeMillis();
        if (this.isAsyncEnabled()) {
            try {
                int localQueue;
                T gotten = this.queue.poll(50L, TimeUnit.MILLISECONDS);
                if (gotten != null) {
                    if (this.dynamic) {
                        if (this.queue.size() == 0) {
                            int localQueue2 = this.queueTicks.incrementAndGet();
                            if (localQueue2 > this.queueThreashold) {
                                this.queueTicks.set(0);
                                int localIdle = this.maximumIdleObjects.incrementAndGet();
                                if (localIdle > this.currentlyActiveObjects) {
                                    this.maximumIdleObjects.set(this.currentlyActiveObjects);
                                }
                            }
                        } else {
                            int localQueue3;
                            int localNew = this.newTicks.decrementAndGet();
                            if (localNew < 0) {
                                this.newTicks.set(0);
                            }
                            if ((localQueue3 = this.queueTicks.decrementAndGet()) < -this.queueThreashold) {
                                this.queueTicks.set(0);
                                int localIdle = this.maximumIdleObjects.decrementAndGet();
                                if (localIdle < 1) {
                                    this.maximumIdleObjects.set(1);
                                }
                            }
                        }
                        int localSuccess = this.successfulRequests.incrementAndGet();
                        if (localSuccess >= this.successThreashold.get()) {
                            this.successfulRequests.set(0);
                            this.successThreashold.set((int)((double)this.successThreashold.get() * 1.25));
                            this.downThreashold.incrementAndGet();
                            this.newThreashold.incrementAndGet();
                            if (this.fineLog) {
                                SelectorThread.logger().log(Level.FINE, "Pool size seems to be working with " + this.currentlyActiveObjects + " total." + "Creation threashold is at " + this.newThreashold.get() + " Drop threashold is at " + this.downThreashold.get());
                            }
                        }
                    }
                    if (this.fineLog) {
                        long waitTime = System.currentTimeMillis() - time;
                        SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.received.new.object", waitTime, this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                    }
                    return gotten;
                }
                if (this.dynamic && (localQueue = this.queueTicks.incrementAndGet()) > this.queueThreashold) {
                    this.queueTicks.set(0);
                    int localIdle = this.maximumIdleObjects.incrementAndGet();
                    if (localIdle > this.currentlyActiveObjects) {
                        this.maximumIdleObjects.set(this.currentlyActiveObjects);
                    }
                }
                this.voteNewObject();
                gotten = this.queue.poll(360L, TimeUnit.SECONDS);
                if (this.fineLog) {
                    long waitTime = System.currentTimeMillis() - time;
                    SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.received.voted.new.object", waitTime, this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                }
                return gotten;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)this.queue.poll();
    }

    public void returnObject(T object) {
        if (this.queue.size() < this.maximumIdleObjects.intValue()) {
            this.validateAndReturn(object);
            if (this.dynamic) {
                int localDown = this.downTicks.decrementAndGet();
                if (localDown < 0) {
                    this.downTicks.set(0);
                }
                if (this.fineLog) {
                    SelectorThread.logger().log(Level.INFO, Messages.format("dynamicpool.returned.objects", this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                }
            }
        } else if (this.dynamic) {
            int localDown = this.downTicks.incrementAndGet();
            int localQueue = this.queueTicks.decrementAndGet();
            if (localDown > this.downThreashold.get()) {
                this.downTicks.set(0);
                if (this.currentlyActiveObjects > this.hardMinActiveObjects) {
                    --this.currentlyActiveObjects;
                    this.objectLib.dispose(object);
                    if (this.fineLog) {
                        SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.excessive.idle.objects", this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                    }
                    if (this.createdLast) {
                        this.newThreashold.incrementAndGet();
                        SelectorThread.logger().log(Level.INFO, "Create-drop with RT = " + this.currentlyActiveObjects + ". newThreashold is " + this.newThreashold.get() + ", downThreashold is " + this.downThreashold);
                    } else {
                        this.downThreashold.decrementAndGet();
                        SelectorThread.logger().log(Level.INFO, "drop-drop with RT = " + this.currentlyActiveObjects + ". newThreashold is " + this.newThreashold.get() + ", downThreashold is " + this.downThreashold);
                    }
                    this.createdLast = false;
                    this.successfulRequests.set(0);
                    this.successThreashold.set((int)((double)this.successThreashold.get() * 0.8));
                } else {
                    if (this.fineLog) {
                        SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.returned.hardminimum", this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                    }
                    this.validateAndReturn(object);
                }
            } else {
                if (this.fineLog) {
                    SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.returned.objects.reduction", this.currentlyActiveObjects, this.hardMaxActiveObjects, this.queue.size(), this.currentlyActiveObjects - this.queue.size()));
                }
                this.validateAndReturn(object);
            }
            if (localQueue < -this.queueThreashold && this.maximumIdleObjects.intValue() > 0) {
                this.queueTicks.set(0);
                int localIdle = this.maximumIdleObjects.decrementAndGet();
                if (localIdle < 1) {
                    this.maximumIdleObjects.set(1);
                }
            }
        } else if (this.currentlyActiveObjects > this.hardMaxActiveObjects) {
            --this.currentlyActiveObjects;
            this.objectLib.dispose(object);
        } else {
            this.validateAndReturn(object);
        }
    }

    private void validateAndReturn(T object) {
        if (this.validate) {
            if (this.objectLib.validate(object)) {
                this.queue.offer(object);
            } else {
                --this.currentlyActiveObjects;
                this.objectLib.dispose(object);
                this.makeNewObject();
            }
        } else {
            this.queue.offer(object);
        }
    }

    public void start(int threads) {
        try {
            ExecutorService exec = Executors.newFixedThreadPool(threads);
            SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.starting.threadpool", threads));
            for (int i = 0; i < this.numberOfObjects; ++i) {
                ++this.currentlyActiveObjects;
                exec.execute(new Runnable(){

                    public void run() {
                        long startTime = System.currentTimeMillis();
                        Object newObject = DynamicPool.this.objectLib.initializeObject();
                        SelectorThread.logger().log(Level.INFO, Messages.format("dynamicpool.newinstance.creation.time", System.currentTimeMillis() - startTime));
                        DynamicPool.this.queue.offer(newObject);
                    }
                });
            }
            SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.shutdown.command", new Object[0]));
            exec.shutdown();
            if (exec.awaitTermination(this.numberOfObjects * 30, TimeUnit.SECONDS)) {
                SelectorThread.logger().log(Level.FINE, Messages.format("dynamicpool.init.finished", new Object[0]));
            } else {
                if (this.numberOfObjects > 1 && threads > 1) {
                    SelectorThread.logger().log(Level.SEVERE, Messages.format("dynamicpool.init.err", this.currentlyActiveObjects, this.numberOfObjects));
                }
                exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.currentlyActiveObjects = this.queue.size();
            SelectorThread.logger().log(Level.WARNING, Messages.format("dynamicpool.init.interrupted", new Object[0]));
            Thread.currentThread().interrupt();
        }
    }

    private void voteNewObject() {
        int localNew;
        if (this.currentlyActiveObjects < this.hardMaxActiveObjects && this.currentlyGeneratingObjects < this.maxGeneratingObjects && (localNew = this.newTicks.addAndGet(2)) > this.newThreashold.get()) {
            this.newTicks.set(0);
            this.makeNewObject();
        }
        if (this.currentlyActiveObjects < this.hardMinActiveObjects) {
            this.makeNewObject();
        }
    }

    private void makeNewObject() {
        if (this.currentlyActiveObjects < this.hardMaxActiveObjects && this.currentlyGeneratingObjects < this.maxGeneratingObjects) {
            ++this.currentlyActiveObjects;
            ++this.currentlyGeneratingObjects;
            this.objectGenerator.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        long startTime = System.currentTimeMillis();
                        Object newObject = DynamicPool.this.objectLib.initializeObject();
                        SelectorThread.logger().log(Level.INFO, Messages.format("dynamicpool.new.instance", DynamicPool.this.currentlyActiveObjects, System.currentTimeMillis() - startTime));
                        DynamicPool.this.queue.offer(newObject);
                    }
                    catch (Exception e) {
                        DynamicPool.this.currentlyActiveObjects--;
                    }
                    finally {
                        DynamicPool.this.currentlyGeneratingObjects--;
                    }
                }
            });
            if (this.createdLast) {
                this.newThreashold.decrementAndGet();
                SelectorThread.logger().log(Level.INFO, "Create-create with RT = " + this.currentlyActiveObjects + ". newThreashold is " + this.newThreashold.get() + ", downThreashold is " + this.downThreashold);
            } else {
                this.downThreashold.incrementAndGet();
                SelectorThread.logger().log(Level.INFO, "Drop-create with RT = " + this.currentlyActiveObjects + ". newThreashold is " + this.newThreashold.get() + ", downThreashold is " + this.downThreashold);
            }
            this.createdLast = true;
            this.successfulRequests.set(0);
            this.successThreashold.set((int)((double)this.successThreashold.get() * 0.8));
        }
    }

    public void stop() {
        for (Object thing : this.queue) {
            this.objectLib.dispose(thing);
        }
        this.queue.clear();
        try {
            this.objectGenerator.shutdown();
            this.objectGenerator.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            SelectorThread.logger().log(Level.WARNING, Messages.format("dynamicpool.shutdown.interrupted", new Object[0]));
        }
    }

    public int getNumberOfObjects() {
        return this.currentlyActiveObjects;
    }

    public BlockingQueue<T> getObjectQueue() {
        return this.queue;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    private void logDynamicStatus() {
        if (this.dynamic) {
            SelectorThread.logger().log(Level.INFO, Messages.format("dynamicpool.status", this.numberOfObjects, this.hardMinActiveObjects, this.hardMaxActiveObjects));
        } else {
            SelectorThread.logger().log(Level.INFO, Messages.format("dynamicpool.disabled", this.numberOfObjects));
        }
    }
}

