/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;

public class ClientJarMakerRegistry {
    private static ClientJarMakerRegistry theRegistry;
    Map registeredThreads = new Hashtable();

    protected ClientJarMakerRegistry() {
    }

    public static synchronized ClientJarMakerRegistry getInstance() {
        if (theRegistry == null) {
            theRegistry = new ClientJarMakerRegistry();
        }
        return theRegistry;
    }

    public void register(String moduleID, Thread clientJarMaker) {
        this.registeredThreads.put(moduleID, clientJarMaker);
    }

    public boolean isRegistered(String moduleID) {
        return this.registeredThreads.containsKey(moduleID);
    }

    public void unregister(String moduleID) {
        this.registeredThreads.remove(moduleID);
    }

    public void waitForCompletion(String moduleID) {
        Thread maker = (Thread)this.registeredThreads.get(moduleID);
        if (maker == null) {
            return;
        }
        try {
            maker.join();
        }
        catch (InterruptedException e) {
            StringManager localStrings = StringManager.getManager(ClientJarMakerRegistry.class);
            DOLUtils.getDefaultLogger().log(Level.SEVERE, localStrings.getString("enterprise.deployment.error_creating_client_jar", (Object)e.getLocalizedMessage()), e);
        }
    }
}

