/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.javaee.core.deployment.EarHandler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DolProvider
implements ApplicationMetaDataProvider<Application> {
    @Inject
    ArchivistFactory archivistFactory;
    @Inject(name="application_deploy", optional=true)
    protected ApplicationVisitor deploymentVisitor = null;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    Habitat habitat;
    @Inject
    DasConfig dasConfig;
    private static String WRITEOUT_XML = System.getProperty("writeout.xml");

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{Application.class, WebBundleDescriptor.class}, null);
    }

    public Application load(DeploymentContext dc) throws IOException {
        ReadableArchive sourceArchive = dc.getSource();
        ClassLoader cl = dc.getClassLoader();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String name = params.name();
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        archivist.setAnnotationProcessingRequested(true);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        archivist.setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setXMLValidation(false);
        }
        archivist.setRuntimeXMLValidation(false);
        File deploymentPlan = params.deploymentplan;
        this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive);
        long start = System.currentTimeMillis();
        EarHandler.ApplicationHolder holder = (EarHandler.ApplicationHolder)dc.getModuleMetaData(EarHandler.ApplicationHolder.class);
        Application application = null;
        if (holder != null) {
            application = holder.app;
            ApplicationArchivist appArchivist = (ApplicationArchivist)ApplicationArchivist.class.cast(archivist);
            appArchivist.setClassLoader(cl);
            appArchivist.setManifest(sourceArchive.getManifest());
            try {
                appArchivist.openWith(application, sourceArchive);
            }
            catch (SAXParseException e) {
                throw new IOException(e);
            }
            application.setRegistrationName(name);
        }
        if (application == null) {
            try {
                application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
            }
            catch (SAXParseException e) {
                throw new IOException(e);
            }
        }
        this.validateApplication(application, dc);
        if (this.deploymentVisitor != null) {
            this.deploymentVisitor.accept(application);
        }
        if (Boolean.valueOf(WRITEOUT_XML).booleanValue()) {
            this.saveAppDescriptor(application, dc);
        }
        System.out.println("DOL Loading time" + (System.currentTimeMillis() - start));
        if (application.isVirtual()) {
            dc.addModuleMetaData((Object)application.getStandaloneBundleDescriptor());
            for (RootDeploymentDescriptor extension : application.getStandaloneBundleDescriptor().getExtensionsDescriptors()) {
                dc.addModuleMetaData((Object)extension);
            }
        }
        return application;
    }

    protected void handleDeploymentPlan(File deploymentPlan, Archivist archivist, ReadableArchive sourceArchive) throws IOException {
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.open(deploymentPlan.toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
        }
    }

    protected void saveAppDescriptor(Application application, DeploymentContext context) throws IOException {
        if (application != null) {
            ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
            context.getScratchDir("xml").mkdirs();
            WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
            this.descriptorArchivist.write(application, archive, archive2);
            this.applicationArchivist.copyExtraElements(archive, archive2);
        }
    }

    protected void validateApplication(Application app, DeploymentContext dc) {
        if (app != null) {
            app.setClassLoader(dc.getClassLoader());
            app.visit((ApplicationVisitor)new ApplicationValidator());
        }
    }
}

