/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarClassLoader
extends URLClassLoader {
    private final List<ClassLoaderHolder> delegates = new LinkedList<ClassLoaderHolder>();
    private final Method findClass;
    private final Method findResource;
    private final Method findResources;
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private final boolean checkParent;

    public EarClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
        this.checkParent = urls != null && urls.length > 0;
        try {
            this.findClass = ClassLoader.class.getDeclaredMethod("findClass", String.class);
            this.findClass.setAccessible(true);
            this.findResource = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            this.findResource.setAccessible(true);
            this.findResources = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            this.findResources.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void addModuleClassLoader(String moduleName, ClassLoader cl) {
        this.delegates.add(new ClassLoaderHolder(moduleName, cl));
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        for (ClassLoaderHolder clh : this.delegates) {
            if (!moduleName.equals(clh.moduleName)) continue;
            return clh.loader;
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String s) throws ClassNotFoundException {
        if (this.classes.containsKey(s)) {
            return this.classes.get(s);
        }
        if (this.checkParent) {
            try {
                return super.findClass(s);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                Class clazz = (Class)this.findClass.invoke((Object)clh.loader, s);
                if (clazz == null) continue;
                this.classes.put(s, clazz);
                return clazz;
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        throw new ClassNotFoundException(s);
    }

    @Override
    public URL findResource(String s) {
        URL url = null;
        if (this.checkParent && (url = super.findResource(s)) != null) {
            return url;
        }
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                url = (URL)this.findResource.invoke((Object)clh.loader, s);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String s) throws IOException {
        Enumeration<URL> result;
        if (this.checkParent && (result = super.findResources(s)) != null) {
            return result;
        }
        Vector urls = new Vector();
        for (ClassLoaderHolder clh : this.delegates) {
            try {
                Enumeration enumeration = (Enumeration)this.findResources.invoke((Object)clh.loader, s);
                while (enumeration.hasMoreElements()) {
                    urls.add(enumeration.nextElement());
                }
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        return urls.elements();
    }

    private class ClassLoaderHolder {
        final ClassLoader loader;
        final String moduleName;

        private ClassLoaderHolder(String moduleName, ClassLoader loader) {
            this.loader = loader;
            this.moduleName = moduleName;
        }
    }
}

