/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.EarClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class EarDeployer
implements Deployer {
    @Inject
    Habitat habitat;
    @Inject
    Deployment deployment;
    @Inject
    ServerEnvironment env;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    ArchiveFactory archiveFactory;
    static final Logger logger = LogDomains.getLogger(EarDeployer.class, (String)"javax.enterprise.system.tools.deployment");

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public Object loadMetaData(Class type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        Application application = (Application)context.getModuleMetaData(Application.class);
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String appName = deployParams.name();
        final CompositeApplicationInfo appInfo = new CompositeApplicationInfo(context.getSource(), appName);
        for (Object m : context.getModuleMetadata()) {
            appInfo.addMetaData(m);
        }
        final Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = this.initSubContext(application, context);
        try {
            this.doOnAllBundles(application, new BundleBlock<ModuleInfo>(){

                @Override
                public ModuleInfo doBundle(ModuleDescriptor bundle) throws Exception {
                    ModuleInfo info = EarDeployer.this.prepareBundle(bundle, (ExtendedDeploymentContext)contextPerModules.get(bundle));
                    appInfo.addModule(info);
                    return info;
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        context.addModuleMetaData((Object)appInfo);
        return true;
    }

    private Collection<ModuleDescriptor<BundleDescriptor>> doOnAllTypedBundles(Application application, XModuleType type, BundleBlock runnable) throws Exception {
        Collection typedBundles = application.getModuleDescriptorsByType(type);
        for (ModuleDescriptor module : typedBundles) {
            runnable.doBundle(module);
        }
        return typedBundles;
    }

    private void doOnAllBundles(Application application, BundleBlock runnable) throws Exception {
        HashSet bundles = new HashSet();
        bundles.addAll(application.getModules());
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.RAR, runnable));
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.EJB, runnable));
        bundles.removeAll(this.doOnAllTypedBundles(application, XModuleType.WAR, runnable));
        for (ModuleDescriptor bundle : bundles) {
            runnable.doBundle(bundle);
        }
    }

    private ModuleInfo prepareBundle(ModuleDescriptor md, final ExtendedDeploymentContext bundleContext) throws Exception {
        LinkedList orderedContainers = null;
        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "hk2-agent");
        ProgressTracker tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                for (EngineRef module : this.get("prepared", EngineRef.class)) {
                    module.clean(bundleContext, logger);
                }
            }
        };
        try {
            orderedContainers = this.deployment.setupContainerInfos((DeploymentContext)bundleContext, report);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.deployment.prepareModule(orderedContainers, md.getArchiveUri(), (DeploymentContext)bundleContext, report, tracker);
    }

    public ApplicationContainer load(Container container, DeploymentContext context) {
        return null;
    }

    public void unload(ApplicationContainer appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }

    public Map<ModuleDescriptor, ExtendedDeploymentContext> initSubContext(Application application, final DeploymentContext context) {
        HashMap<ModuleDescriptor, ExtendedDeploymentContext> results = new HashMap<ModuleDescriptor, ExtendedDeploymentContext>();
        for (final BundleDescriptor bd : application.getBundleDescriptors()) {
            ReadableArchive subArchive;
            if (results.containsKey(bd.getModuleDescriptor())) continue;
            try {
                subArchive = context.getSource().getSubArchive(bd.getModuleDescriptor().getArchiveUri());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
            DeploymentContextImpl subContext = new DeploymentContextImpl(logger, context.getSource(), context.getCommandParameters(OpsParams.class), this.env){

                public ClassLoader getClassLoader() {
                    try {
                        EarClassLoader appCl = (EarClassLoader)EarClassLoader.class.cast(context.getClassLoader());
                        return appCl.getModuleClassLoader(bd.getModuleDescriptor().getArchiveUri());
                    }
                    catch (ClassCastException e) {
                        return context.getClassLoader();
                    }
                }

                public ClassLoader getFinalClassLoader() {
                    return context.getFinalClassLoader();
                }

                public ReadableArchive getSource() {
                    return subArchive;
                }

                public File getScratchDir(String subDirName) {
                    String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                    return new File(super.getScratchDir(subDirName), modulePortion);
                }

                public <T> T getModuleMetaData(Class<T> metadataType) {
                    try {
                        return metadataType.cast(bd);
                    }
                    catch (Exception e) {
                        if (RootDeploymentDescriptor.class.isAssignableFrom(metadataType)) {
                            for (RootDeploymentDescriptor extension : bd.getExtensionsDescriptors(metadataType)) {
                                if (extension == null) continue;
                                try {
                                    return metadataType.cast(extension);
                                }
                                catch (Exception e1) {
                                }
                            }
                        }
                        return (T)context.getModuleMetaData(metadataType);
                    }
                }
            };
            results.put(bd.getModuleDescriptor(), (ExtendedDeploymentContext)subContext);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BundleBlock<T> {
        public T doBundle(ModuleDescriptor var1) throws Exception;
    }

    private class CompositeApplicationInfo
    extends ApplicationInfo {
        Application application;

        private CompositeApplicationInfo(ReadableArchive source, String name) {
            super(source, name);
            this.application = null;
        }

        public void load(ExtendedDeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
            this.application = (Application)context.getModuleMetaData(Application.class);
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.load(contextPerModules.get(md), report, tracker);
            }
        }

        public void start(DeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.start((DeploymentContext)contextPerModules.get(md), report, tracker);
            }
        }

        public void unload(ExtendedDeploymentContext context, ActionReport report) {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.unload(contextPerModules.get(md), report);
            }
        }

        public void clean(ExtendedDeploymentContext context) throws Exception {
            if (this.application == null) {
                return;
            }
            Map<ModuleDescriptor, ExtendedDeploymentContext> contextPerModules = EarDeployer.this.initSubContext(this.application, (DeploymentContext)context);
            for (ModuleInfo module : super.getModuleInfos()) {
                ModuleDescriptor md = this.application.getModuleDescriptorByUri(module.getName());
                module.clean(contextPerModules.get(md));
            }
        }
    }
}

