/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.EarClassLoader;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

@Service(name="ear")
public class EarHandler
extends AbstractArchiveHandler
implements CompositeHandler {
    @Inject
    Deployment deployment;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject
    DasConfig dasConfig;

    public String getArchiveType() {
        return "ear";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return DeploymentUtils.isEAR((ReadableArchive)archive);
    }

    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        super.expand(source, target, context);
        ReadableArchive source2 = this.archiveFactory.openArchive(target.getURI());
        ApplicationHolder holder = this.getApplicationHolder(source2, context, false);
        for (ModuleDescriptor md : holder.app.getModules()) {
            String moduleUri = md.getArchiveUri();
            try {
                ReadableArchive subArchive = source.getSubArchive(moduleUri);
                ArchiveHandler subHandler = this.deployment.getArchiveHandler(subArchive);
                if (subHandler == null) continue;
                WritableArchive subTarget = target.createSubArchive(FileUtils.makeFriendlyFilename((String)moduleUri));
                subHandler.expand(subArchive, subTarget, context);
                target.closeEntry(subTarget);
            }
            catch (IOException ioe) {
                this._logger.log(Level.FINE, "Exception while processing " + moduleUri, ioe);
            }
        }
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        EarClassLoader cl;
        ReadableArchive archive = context.getSource();
        ApplicationHolder holder = this.getApplicationHolder(archive, context, true);
        try {
            cl = new EarClassLoader(ASClassLoaderUtil.getAppLibDirLibraries((File)context.getSourceDir(), (String)holder.app.getLibraryDirectory()), parent);
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "error in adding libraries in library directory", e);
            throw new RuntimeException(e);
        }
        for (ModuleDescriptor md : holder.app.getModules()) {
            ReadableArchive sub = null;
            try {
                sub = archive.getSubArchive(md.getArchiveUri());
            }
            catch (IOException e) {
                this._logger.log(Level.FINE, "Sub archive " + md.getArchiveUri() + " seems unreadable", e);
            }
            if (sub == null) continue;
            try {
                ArchiveHandler handler = this.deployment.getArchiveHandler(sub);
                if (handler == null) continue;
                DeploymentContextImpl subContext = new DeploymentContextImpl(context.getLogger(), sub, context.getCommandParameters(DeployCommandParameters.class), this.env){

                    public File getScratchDir(String subDirName) {
                        String modulePortion = Util.getURIName((URI)this.getSource().getURI());
                        return new File(super.getScratchDir(subDirName), modulePortion);
                    }
                };
                subContext.setArchiveHandler(context.getArchiveHandler());
                ClassLoader subCl = handler.getClassLoader((ClassLoader)cl, (DeploymentContext)subContext);
                cl.addModuleClassLoader(md.getArchiveUri(), subCl);
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Cannot find a class loader for submodule", e);
            }
        }
        return cl;
    }

    public boolean accept(ReadableArchive source, String entryName) {
        return entryName.startsWith("META-INF");
    }

    private ApplicationHolder getApplicationHolder(ReadableArchive source, DeploymentContext context, boolean isDirectory) {
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder == null || holder.app == null) {
            try {
                long start = System.currentTimeMillis();
                ApplicationArchivist archivist = (ApplicationArchivist)this.habitat.getComponent(ApplicationArchivist.class);
                archivist.setAnnotationProcessingRequested(true);
                String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
                archivist.setXMLValidationLevel(xmlValidationLevel);
                if (xmlValidationLevel.equals("none")) {
                    archivist.setXMLValidation(false);
                }
                holder = new ApplicationHolder(archivist.createApplication(source, isDirectory));
                System.out.println("time to read application.xml " + (System.currentTimeMillis() - start));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXParseException e) {
                throw new RuntimeException(e);
            }
            context.addModuleMetaData((Object)holder);
        }
        if (holder.app == null) {
            throw new RuntimeException("Cannot read application metadata");
        }
        return holder;
    }

    public final class ApplicationHolder {
        final Application app;

        private ApplicationHolder(Application app) {
            this.app = app;
        }
    }
}

