/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.annotation.AMXConfigVoid;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.FeatureAvailability;
import com.sun.appserv.management.util.misc.TypeCast;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigImplBase;
import org.glassfish.admin.amx.config.AMXConfigLoaderMBean;
import org.glassfish.admin.amx.config.ConfiguredHelper;
import org.glassfish.admin.amx.config.ConfiguredHelperRegistry;
import org.glassfish.admin.amx.config.DelegateToConfigBeanDelegate;
import org.glassfish.admin.amx.mbean.AMXImplBase;
import org.glassfish.admin.amx.mbean.MBeanImplBase;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.admin.amx.util.ImplUtil;
import org.glassfish.admin.amx.util.ObjectNames;
import org.glassfish.admin.mbeanserver.PendingConfigBeanJob;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.glassfish.api.amx.AMXConfigInfo;
import org.glassfish.api.amx.AMXMBeanMetadata;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMXConfigLoader
extends MBeanImplBase
implements AMXConfigLoaderMBean,
TransactionListener {
    private final MBeanServer mMBeanServer;
    private volatile AMXConfigLoaderThread mLoaderThread;
    private final Transactions mTransactions;
    private final Logger mLogger = ImplUtil.getLogger();
    private final PendingConfigBeans mPendingConfigBeans;

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXConfigLoader(MBeanServer mbeanServer, PendingConfigBeans pending, Transactions transactions) {
        this.mTransactions = transactions;
        if (this.mTransactions == null) {
            throw new IllegalStateException();
        }
        this.mPendingConfigBeans = pending;
        this.mMBeanServer = mbeanServer;
    }

    private void configBeanRemoved(ConfigBean cb) {
        if (cb.getObjectName() != null) {
            ImplUtil.unregisterAMXMBeans(this.mMBeanServer, cb.getObjectName());
        } else {
            this.mPendingConfigBeans.remove(cb);
        }
    }

    private void issueAttributeChange(ConfigBean cb, String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        ObjectName objectName = cb.getObjectName();
        if (objectName == null) {
            throw new IllegalArgumentException("Can't issue attribute change for null ObjectName for ConfigBean " + cb.getProxyType().getName());
        }
        boolean changed = false;
        if (oldValue != null) {
            changed = !oldValue.equals(newValue);
        } else if (newValue != null) {
            boolean bl = changed = !newValue.equals(oldValue);
        }
        if (changed) {
            AMXConfigImplBase amx = (AMXConfigImplBase)AMXConfigImplBase.class.cast(AMXImplBase.__getObjectRef__(this.mMBeanServer, objectName));
            amx.issueAttributeChangeForXmlAttrName(xmlAttrName, oldValue, newValue, whenChanged);
        }
    }

    private void sortAndDispatch(List<PropertyChangeEvent> events, long whenChanged) {
        String propertyName;
        Object source;
        Object newValue;
        Object oldValue;
        ArrayList<ConfigBean> newConfigBeans = new ArrayList<ConfigBean>();
        ArrayList<PropertyChangeEvent> remainingEvents = new ArrayList<PropertyChangeEvent>();
        for (PropertyChangeEvent event : events) {
            ConfigBean cb;
            ConfigBeanProxy cbp;
            oldValue = event.getOldValue();
            newValue = event.getNewValue();
            source = event.getSource();
            propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cbp = (ConfigBeanProxy)newValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                Class proxyClass = cb.getProxyType();
                boolean doWait = this.amxIsRunning();
                this.handleConfigBean(cb, doWait);
                newConfigBeans.add(cb);
                continue;
            }
            if (newValue == null && oldValue instanceof ConfigBeanProxy && this.amxIsRunning()) {
                cbp = (ConfigBeanProxy)oldValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                this.configBeanRemoved(cb);
                continue;
            }
            remainingEvents.add(event);
        }
        if (this.amxIsRunning()) {
            for (PropertyChangeEvent event : remainingEvents) {
                String sourceString;
                oldValue = event.getOldValue();
                newValue = event.getNewValue();
                source = event.getSource();
                propertyName = event.getPropertyName();
                String string = sourceString = source instanceof ConfigBeanProxy ? ConfigSupport.proxyType((ConfigBeanProxy)((ConfigBeanProxy)source)).getName() : "" + source;
                if (source instanceof ConfigBeanProxy) {
                    ConfigBeanProxy cbp = (ConfigBeanProxy)source;
                    ConfigBean cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                    Class proxyClass = ConfigSupport.proxyType((ConfigBeanProxy)cbp);
                    if (cb.getObjectName() == null) {
                        if (newConfigBeans.contains(cb)) continue;
                        this.handleConfigBean(cb, false);
                        newConfigBeans.add(cb);
                        continue;
                    }
                    this.issueAttributeChange(cb, propertyName, oldValue, newValue, whenChanged);
                    continue;
                }
                AMXConfigLoader.debug("AMXConfigLoader.sortAndDispatch: WARNING: source is not a ConfigBean");
            }
        }
    }

    public void transactionCommited(List<PropertyChangeEvent> changes) {
        this.sortAndDispatch(changes, System.currentTimeMillis());
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    @Override
    protected void postRegisterHook(Boolean registrationDone) {
        super.postRegisterHook(registrationDone);
        if (registrationDone.booleanValue()) {
            this.mPendingConfigBeans.swapTransactionListener((TransactionListener)this);
        }
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
    }

    @Override
    protected void postDeregisterHook() {
        super.postDeregisterHook();
        this.mTransactions.removeTransactionsListener((TransactionListener)this);
    }

    protected void handleConfigBean(ConfigBean cb, boolean waitDone) {
        if (cb.getObjectName() == null) {
            PendingConfigBeanJob job = this.mPendingConfigBeans.add(cb, waitDone);
            if (waitDone) {
                try {
                    job.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static AMXConfigInfo getAMXConfigInfo(ConfigBean cb) {
        Class theClass = cb.getProxyType();
        AMXConfigInfo amxConfigInfo = theClass.getAnnotation(AMXConfigInfo.class);
        if (amxConfigInfo == null) {
            throw new IllegalArgumentException("ConfigBean has no @AMXConfigInfo: " + theClass.getName());
        }
        return amxConfigInfo;
    }

    private static ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = AMXConfigLoader.asConfigBean(configBean.parent());
        if (parent != null) {
            AMXConfigInfo amxConfigInfo;
            AMXConfigInfoResolver resolver;
            ObjectName parentObjectName = parent.getObjectName();
            if (parentObjectName == null && (resolver = new AMXConfigInfoResolver(amxConfigInfo = AMXConfigLoader.getAMXConfigInfo(parent))).amxInterface() == AMXConfigVoid.class) {
                parent = AMXConfigLoader.getActualParent(parent);
            }
        } else if (!configBean.getProxyType().getName().endsWith("Domain")) {
            AMXConfigLoader.debug("WARNING: parent is null for " + configBean.getProxyType().getName() + " (bug in ConfigBeans)");
        }
        return parent;
    }

    private static ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = AMXConfigLoader.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = parent.getObjectName();
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        return o instanceof ConfigBean ? (ConfigBean)o : null;
    }

    public synchronized void start() {
        if (this.mLoaderThread == null) {
            this.mLoaderThread = new AMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.setDaemon(true);
            this.mLoaderThread.start();
            ObjectName objectName = JMXUtil.newObjectName((String)"amx-support", (String)"name=amx-config-loader");
            try {
                this.mMBeanServer.registerMBean(this, objectName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized boolean amxIsRunning() {
        return this.mLoaderThread != null;
    }

    private ObjectName registerConfigBeanAsMBean(ConfigBean cb) {
        boolean isVoid;
        ObjectName objectName = null;
        AMXConfigInfo info = AMXConfigLoader.getAMXConfigInfo(cb);
        boolean bl = isVoid = info != null && info.amxInterfaceName().equals(AMXConfigVoid.class.getName());
        if (info != null && !isVoid) {
            ConfigBean parentCB = AMXConfigLoader.getActualParent(cb);
            if (parentCB != null && parentCB.getObjectName() == null) {
                this.registerConfigBeanAsMBean(parentCB);
            }
            objectName = this._registerConfigBeanAsMBean(cb, parentCB);
            assert (cb.getObjectName() != null);
        } else if (isVoid) {
            AMXConfigLoader.debug("NOTE: ConfigBean has AMXConfigInfo specifying AMXConfigVoid: " + cb.getProxyType().getName() + " (IGNORING)");
        } else {
            AMXConfigLoader.debug("NOTE: ConfigBean has no @AMXConfigInfo: " + cb.getProxyType().getName() + " (IGNORING)");
        }
        return objectName;
    }

    private AMXMBeanMetadata getAMXMBeanMetadata(ConfigBean cb) {
        Class cbClass = cb.getProxyType();
        AMXMBeanMetadata metadata = cbClass.getAnnotation(AMXMBeanMetadata.class);
        if (metadata == null) {
            metadata = AMXConfigInfo.class.getAnnotation(AMXMBeanMetadata.class);
        }
        return metadata;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = cb.getObjectName();
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && parentCB.getObjectName() == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        AMXConfigInfo amxConfigInfo = AMXConfigLoader.getAMXConfigInfo(cb);
        AMXConfigInfoResolver resolver = new AMXConfigInfoResolver(amxConfigInfo);
        Class<? extends AMXConfig> amxInterface = resolver.amxInterface();
        if (amxInterface != AMXConfigVoid.class) {
            boolean autoInterface;
            boolean bl = autoInterface = amxInterface == AMXConfig.class;
            Class supplementaryIntf = autoInterface ? (cbClass.isInterface() ? cbClass : null) : null;
            AMXMBeanMetadata metadata = this.getAMXMBeanMetadata(cb);
            objectName = this.buildObjectName(cb, resolver);
            objectName = this.createAndRegister(cb, amxInterface, supplementaryIntf, objectName);
            ImplUtil.getLogger().fine("REGISTERED MBEAN: " + JMXUtil.toString((ObjectName)objectName));
        }
        return objectName;
    }

    protected static String getFullType(ConfigBean cb, ObjectName proposedObjectName) {
        String fullType = "";
        if (cb != null) {
            ObjectName objectName = proposedObjectName != null ? proposedObjectName : cb.getObjectName();
            String j2eeType = objectName.getKeyProperty("j2eeType");
            ConfigBean parent = AMXConfigLoader.getActualParent(cb);
            fullType = parent == null ? j2eeType : AMXConfigLoader.getFullType(parent, null) + "." + j2eeType;
        }
        return fullType;
    }

    private ObjectName createAndRegister(ConfigBean cb, Class<? extends AMXConfig> amxInterface, Class<?> supplementaryIntf, ObjectName objectNameIn) {
        ObjectName objectName = objectNameIn;
        String j2eeType = objectNameIn.getKeyProperty("j2eeType");
        String fullType = AMXConfigLoader.getFullType(cb, objectName);
        DelegateToConfigBeanDelegate delegate = new DelegateToConfigBeanDelegate(cb);
        ObjectName parentObjectName = AMXConfigLoader.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            if (amxInterface == DomainConfig.class) {
                parentObjectName = ObjectNames.getInstance().getDomainRootObjectName();
            } else {
                throw new IllegalArgumentException("All AMXConfig MBeans must have a parent!  No parent for " + cb.getProxyType().getName());
            }
        }
        AMXConfigImplBase impl = new AMXConfigImplBase(j2eeType, fullType, parentObjectName, amxInterface, supplementaryIntf, delegate);
        try {
            ObjectInstance instance = this.mMBeanServer.registerMBean(impl, objectNameIn);
            objectName = instance.getObjectName();
            cb.setObjectName(objectName);
        }
        catch (JMException e) {
            AMXConfigLoader.debug(ExceptionUtil.toString((Throwable)e));
            objectName = null;
        }
        return objectName;
    }

    private String getJ2EETypeField(Class<? extends AMXConfig> amxInterface) {
        String j2eeType = null;
        try {
            j2eeType = (String)ClassUtil.getFieldValue(amxInterface, (String)"J2EE_TYPE");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return j2eeType;
    }

    private String getJ2EEType(ConfigBean cb, AMXConfigInfoResolver info) {
        Class<? extends AMXConfig> amxInterface = info.amxInterface();
        if (amxInterface == null) {
            throw new IllegalArgumentException("No amx interface for: " + info);
        }
        String j2eeType = null;
        if (amxInterface != AMXConfig.class) {
            j2eeType = this.getJ2EETypeField(amxInterface);
        }
        if (j2eeType == null) {
            AMXConfigLoader.debug("Getting j2eeType for: " + amxInterface.getName());
            j2eeType = info.j2eeType();
            if (j2eeType.length() == 0) {
                String configInterfaceName = cb.getProxyType().getName().replace(".", "_");
                j2eeType = "X-CFG-" + configInterfaceName;
                AMXConfigLoader.debug("Using DERIVED j2eeType of " + j2eeType + " for " + configInterfaceName);
            }
        }
        assert (j2eeType != null && j2eeType.startsWith("X-"));
        if (j2eeType == null) {
            throw new RuntimeException("AMXConfigLoader.getJ2EEType: j2eeType is null");
        }
        if (!j2eeType.startsWith("X-")) {
            throw new RuntimeException("AMXConfigLoader.getJ2EEType: j2eeType just start with X-");
        }
        return j2eeType;
    }

    public static String getName(ConfigBean cb, AMXConfigInfo infoIn) {
        AMXConfigInfo info;
        String name = null;
        ConfiguredHelper helper = ConfiguredHelperRegistry.getInstance(cb.getProxyType());
        String nameHint = helper.getNameHint();
        AMXConfigInfo aMXConfigInfo = info = infoIn == null ? AMXConfigLoader.getAMXConfigInfo(cb) : infoIn;
        if (info.singleton()) {
            name = "na";
        } else if (nameHint == null) {
            name = "MISSING_NAME__KEY_MUST_BE_SPECIFIED_IN_INTERFACE";
        } else if (helper.nameHintIsElement()) {
            List leaf = cb.leafElements(nameHint);
            if (leaf != null) {
                List items = TypeCast.checkList((List)leaf, String.class);
                if (items.size() != 1) {
                    throw new IllegalArgumentException("Can't find sub-element of type " + nameHint + " in " + cb.getProxyType().getName());
                }
                name = (String)items.get(0);
            }
        } else {
            name = cb.rawAttribute(nameHint);
        }
        if (name == null) {
            throw new IllegalStateException("Can't find name for @Configured " + cb.getProxyType().getName() + ", nameHint = " + nameHint);
        }
        name = AMXConfigLoader.whackIllegals(name);
        return name;
    }

    private static String whackIllegals(String s) {
        int sub = 95;
        String result = s.replace(':', '_');
        result = result.replace(',', '_');
        return result;
    }

    private ObjectName buildObjectName(ConfigBean cb, AMXConfigInfoResolver info) {
        ObjectName parentObjectName;
        String j2eeType = this.getJ2EEType(cb, info);
        String name = AMXConfigLoader.getName(cb, info.getAMXConfigInfo());
        String parentProps = "";
        String domain = "amx";
        ConfigBean parent = AMXConfigLoader.getActualParent(cb);
        if (parent != null && (parentObjectName = parent.getObjectName()) != null) {
            domain = parentObjectName.getDomain();
            String ancestorProps = Util.getAdditionalProps((ObjectName)parentObjectName);
            AMXConfigInfo parentAMXConfigInfo = AMXConfigLoader.getAMXConfigInfo(parent);
            String parentProp = parentAMXConfigInfo.omitAsAncestorInChildObjectName() ? "" : Util.getSelfProp((ObjectName)parentObjectName);
            parentProps = Util.concatenateProps((String)parentProp, (String)ancestorProps);
        }
        String requiredProps = Util.makeRequiredProps((String)j2eeType, (String)name);
        String allProps = Util.concatenateProps((String)requiredProps, (String)parentProps);
        ObjectName objectName = Util.newObjectName((String)domain, (String)allProps);
        return objectName;
    }

    private final class AMXConfigLoaderThread
    extends Thread {
        private final PendingConfigBeans mPending;
        volatile boolean mQuit;

        AMXConfigLoaderThread(PendingConfigBeans pending) {
            super("AMXConfigLoader.AMXConfigLoaderThread");
            this.mQuit = false;
            this.mPending = pending;
        }

        void quit() {
            this.mQuit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectName registerOne(PendingConfigBeanJob job) {
            ConfigBean cb = job.getConfigBean();
            ObjectName objectName = cb.getObjectName();
            try {
                if (objectName == null) {
                    objectName = AMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                job.releaseLatch();
            }
            return objectName;
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        protected void doRun() throws Exception {
            PendingConfigBeanJob job = this.mPending.take();
            while (!this.mQuit && job != null) {
                ObjectName objectName = this.registerOne(job);
                job = this.mPending.peek();
                if (job == null) continue;
                job = this.mPending.take();
            }
            FeatureAvailability.getInstance().registerFeature("AMXReady", (Object)Boolean.TRUE);
            while (!this.mQuit) {
                job = this.mPending.take();
                this.registerOne(job);
            }
        }
    }

    private static final class Job {
        final ConfigBean mConfigBean;
        final CountDownLatch mLatch;

        public Job(ConfigBean configBean, CountDownLatch latch) {
            this.mConfigBean = configBean;
            this.mLatch = latch;
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }
    }
}

