/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityContainer;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContextException;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication> {
    private static final Logger _logger = LogDomains.getLogger(SecurityDeployer.class, (String)"javax.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    private Habitat habitat;
    @Inject
    private PolicyLoader policyLoader;

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        this.generatePolicy(dc);
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        this.removePolicy(dc);
    }

    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        return new DummyApplication();
    }

    public void unload(DummyApplication container, DeploymentContext context) {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        this.cleanSecurityContext(params.name());
    }

    protected void generatePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        String appName = params.name();
        try {
            this.policyLoader.loadPolicy();
            Application app = (Application)dc.getModuleMetaData(Application.class);
            WebBundleDescriptor wbd = null;
            Set webDesc = app.getWebBundleDescriptors();
            Iterator iter = webDesc.iterator();
            if (iter.hasNext()) {
                wbd = (WebBundleDescriptor)iter.next();
            }
            WebSecurityManagerFactory wsmf = (WebSecurityManagerFactory)this.habitat.getComponent(WebSecurityManagerFactory.class);
            wsmf.createManager(wbd, false, this.serverContext);
            String name = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(name);
        }
        catch (IASSecurityException se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, (Throwable)se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        String appName = params.name();
        try {
            WebSecurityManagerFactory wsmf = (WebSecurityManagerFactory)this.habitat.getComponent(WebSecurityManagerFactory.class);
            String[] webcontexts = wsmf.getContextsForApp(appName, true);
            if (webcontexts != null) {
                for (int i = 0; i < webcontexts.length; ++i) {
                    if (webcontexts[i] == null) continue;
                    SecurityUtil.removePolicy(webcontexts[i]);
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, (Throwable)ex);
        }
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private void cleanSecurityContext(String appName) {
        WebSecurityManagerFactory wsmf = (WebSecurityManagerFactory)this.habitat.getComponent(WebSecurityManagerFactory.class);
        ArrayList<WebSecurityManager> managers = wsmf.getManagersForApp(appName, true);
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            try {
                managers.get(i).destroy();
                continue;
            }
            catch (PolicyContextException pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
    }
}

