/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class PersistenceArchivist
extends ExtensionsArchivist {
    protected final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor descriptor) {
        return new PersistenceDeploymentDescriptorFile();
    }

    public DeploymentDescriptorFile getConfigurationDDFile(RootDeploymentDescriptor descriptor) {
        return null;
    }

    public XModuleType getModuleType() {
        return XModuleType.Persistence;
    }

    public boolean supportsModuleType(XModuleType moduleType) {
        return XModuleType.CAR == moduleType || XModuleType.EJB == moduleType;
    }

    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        return this.readPersistenceDeploymentDescriptor(main, archive, "", descriptor);
    }

    protected PersistenceUnitsDescriptor readPersistenceDeploymentDescriptor(Archivist main, ReadableArchive subArchive, String puRoot, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        String subArchiveURI = subArchive.getURI().getSchemeSpecificPart();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PURoot = [{0}] subArchive = {1}", new Object[]{puRoot, subArchiveURI});
        }
        if (descriptor.getExtensionsDescriptors(PersistenceUnitsDescriptor.class, puRoot) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PU has been already read for = {0}", subArchiveURI);
            }
            return null;
        }
        PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)PersistenceUnitsDescriptor.class.cast(super.open(main, subArchive, descriptor));
        if (persistenceUnitsDescriptor != null) {
            persistenceUnitsDescriptor.setParent(descriptor);
            persistenceUnitsDescriptor.setPuRoot(puRoot);
            descriptor.addExtensionDescriptor(PersistenceUnitsDescriptor.class, persistenceUnitsDescriptor, puRoot);
        }
        return persistenceUnitsDescriptor;
    }

    public RootDeploymentDescriptor getDefaultDescriptor() {
        return null;
    }
}

