/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.CookieConfigDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CookieConfigNode
extends DeploymentDescriptorNode {
    private CookieConfigDescriptor descriptor;

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (CookieConfigDescriptor)super.getDescriptor();
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("name", "setName");
        table.put("domain", "setDomain");
        table.put("path", "setPath");
        table.put("comment", "setComment");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("http-only".equals(element.getQName())) {
            this.descriptor.setHttpOnly(Boolean.parseBoolean(value));
        } else if ("secure".equals(element.getQName())) {
            this.descriptor.setSecure(Boolean.parseBoolean(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, CookieConfigDescriptor descriptor) {
        Element myNode = CookieConfigNode.appendChild(parent, nodeName);
        CookieConfigNode.appendTextChild((Node)myNode, "name", descriptor.getName());
        CookieConfigNode.appendTextChild((Node)myNode, "domain", descriptor.getDomain());
        CookieConfigNode.appendTextChild((Node)myNode, "path", descriptor.getPath());
        CookieConfigNode.appendTextChild((Node)myNode, "comment", descriptor.getComment());
        CookieConfigNode.appendTextChild((Node)myNode, "http-only", Boolean.toString(descriptor.isHttpOnly()));
        CookieConfigNode.appendTextChild((Node)myNode, "secure", Boolean.toString(descriptor.isSecure()));
        return myNode;
    }
}

