/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.zip;

import com.sun.enterprise.util.diagnostics.Reporter;
import com.sun.enterprise.util.diagnostics.StackTrace;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    private String dirName = null;
    private ZipOutputStream zipStream = null;
    private byte[] buffer = new byte[16384];
    private ZipItem[] items = null;

    public ZipWriter(String zipFilename, String dirName) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(null);
    }

    public ZipWriter(String zipFilename, String dirName, ZipItem[] theItems) throws ZipFileException {
        this.items = theItems;
        this.init(zipFilename, dirName);
    }

    public ZipWriter(String zipFilename, String dirName, String[] fileList) throws ZipFileException {
        this.init(zipFilename, dirName);
        this.createItemList(fileList);
    }

    public ZipWriter(OutputStream outStream, String dirName, String[] fileList) throws ZipFileException {
        this.init(outStream, dirName);
        this.createItemList(fileList);
    }

    private void init(String outFileName, String dirName) throws ZipFileException {
        try {
            this.init(new FileOutputStream(outFileName), dirName);
        }
        catch (Exception e) {
            throw new ZipFileException(e);
        }
    }

    private void init(OutputStream outStream, String dirName) throws ZipFileException {
        try {
            Reporter.insist((String)dirName);
            File f = new File(dirName);
            Reporter.insist((boolean)f.exists(), (String)("directory (" + dirName + ") doesn't exist"));
            Reporter.insist((boolean)f.isDirectory());
            try {
                dirName = f.getCanonicalPath();
            }
            catch (IOException e) {
                Reporter.warn((Object)("Couldn't getCanonicalPath() for " + dirName));
            }
            dirName = dirName.replace('\\', '/');
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            this.dirName = dirName;
            this.zipStream = new ZipOutputStream(outStream);
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    public void safeWrite() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                try {
                    this.addEntry(this.items[i]);
                    continue;
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
            this.zipStream.close();
        }
        catch (ZipFileException z) {
            Reporter.critical((Object)new StackTrace((Throwable)z));
            throw z;
        }
        catch (Exception e) {
            Reporter.critical((Object)new StackTrace((Throwable)e));
            throw new ZipFileException(e);
        }
    }

    public void write() throws ZipFileException {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                this.addEntry(this.items[i]);
            }
            this.zipStream.close();
        }
        catch (ZipFileException z) {
            Reporter.critical((Object)new StackTrace((Throwable)z));
            throw z;
        }
        catch (Exception e) {
            Reporter.critical((Object)new StackTrace((Throwable)e));
            throw new ZipFileException(e);
        }
    }

    private void addEntry(ZipItem item) throws ZipFileException, IOException {
        int totalBytes = 0;
        FileInputStream in = new FileInputStream(item.file);
        ZipEntry ze = new ZipEntry(item.name);
        this.zipStream.putNextEntry(ze);
        int numBytes = in.read(this.buffer);
        while (numBytes > 0) {
            this.zipStream.write(this.buffer, 0, numBytes);
            totalBytes += numBytes;
            numBytes = in.read(this.buffer);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            Reporter.warn((Object)("Couldn't close the FileInputStream for the file: " + item.file));
        }
        this.zipStream.closeEntry();
        Reporter.verbose((Object)("Wrote " + item.name + " to Zip File.  Wrote " + totalBytes + " bytes."));
    }

    private void createItemList(String[] files) throws ZipFileException {
        try {
            if (files == null) {
                FileListerRelative lister = new FileListerRelative(new File(this.dirName));
                files = lister.getFiles();
            }
            if (files.length <= 0) {
                throw new ZipFileException("No files to add!");
            }
            this.items = new ZipItem[files.length];
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.dirName + files[i]);
                this.items[i] = new ZipItem(f, files[i].replace('\\', '/'));
            }
        }
        catch (Throwable t) {
            throw new ZipFileException(t);
        }
    }

    String getDirName() {
        return this.dirName;
    }

    private static void usage() {
        System.out.println("usage: java com.elf.util.zip.ZipWriter zip-filename directory-name");
        System.exit(1);
    }

    public static void main(String[] args) {
        Reporter.setSeverityLevel((int)0);
        if (args == null || args.length != 2) {
            ZipWriter.usage();
        }
        try {
            ZipWriter zw = new ZipWriter(args[0], args[1]);
            zw.write();
            Reporter.verbose((Object)("" + zw));
        }
        catch (ZipFileException e) {
            Reporter.verbose((Object)("ZipFileException: " + e));
            System.exit(0);
        }
    }
}

