/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;

public class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean hasOriginalRequestAndResponse = false;

    public AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse) {
        this.origRequest = origRequest;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        if (origRequest == servletRequest && origResponse == servletResponse) {
            this.hasOriginalRequestAndResponse = true;
        }
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.hasOriginalRequestAndResponse;
    }

    public void dispatch() {
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
        if (this.servletRequest instanceof HttpServletRequest) {
            String uri = ((HttpServletRequest)this.servletRequest).getRequestURI();
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(uri);
            if (dispatcher != null) {
                this.origRequest.setOkToReinitializeAsync();
                this.origRequest.setAsyncStarted(false);
                pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
            } else {
                log.warning("Unable to acquire RequestDispatcher for original request URI " + uri);
            }
        } else {
            log.warning("Unable to determine original request URI");
        }
    }

    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync();
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path);
        }
    }

    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync();
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path + "in servlet context " + context.getContextPath());
        }
    }

    public void complete() {
        if (!this.origRequest.isAsyncStarted()) {
            throw new IllegalStateException("Request not in async mode");
        }
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    static class Handler
    implements Runnable {
        private final ApplicationDispatcher dispatcher;
        private final ServletRequest request;
        private final ServletResponse response;

        Handler(ApplicationDispatcher dispatcher, ServletRequest request, ServletResponse response) {
            this.dispatcher = dispatcher;
            this.request = request;
            this.response = response;
        }

        public void run() {
            try {
                this.dispatcher.dispatch(this.request, this.response, DispatcherType.ASYNC);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error during ASYNC dispatch", e);
            }
        }
    }
}

