/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;

final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static Logger log = Logger.getLogger(ApplicationFilterConfig.class.getName());
    private StandardContext context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;

    public ApplicationFilterConfig(StandardContext context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public boolean isAsyncSupported() {
        return this.filterDef.isAsyncSupported();
    }

    public long getAsyncTimeout() {
        return this.filterDef.getAsyncTimeout();
    }

    public String getInitParameter(String name) {
        return this.filterDef.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.filterDef.getInitParameterNames();
    }

    public Object getInitAttribute(String name) {
        return this.filterDef.getInitAttribute(name);
    }

    public Enumeration getInitAttributeNames() {
        return this.filterDef.getInitAttributeNames();
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClassName());
        sb.append("]");
        return sb.toString();
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        if (this.filter != null) {
            return this.filter;
        }
        Class<Filter> clazz = this.filterDef.getFilterClass();
        if (clazz == null) {
            ClassLoader classLoader = null;
            String filterClassName = this.filterDef.getFilterClassName();
            classLoader = filterClassName.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
            ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
            clazz = classLoader.loadClass(filterClassName);
        }
        this.filter = clazz.newInstance();
        if (this.context != null) {
            this.context.fireContainerEvent("beforeFilterInitialized", this.filter);
        }
        this.filter.init(this);
        if (this.context != null) {
            this.context.fireContainerEvent("afterFilterInitialized", this.filter);
        }
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            if (this.context != null) {
                this.context.fireContainerEvent("beforeFilterDestroyed", this.filter);
            }
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                    SecurityUtil.remove(this.filter);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                }
            } else {
                this.filter.destroy();
            }
            if (this.context != null) {
                this.context.fireContainerEvent("afterFilterDestroyed", this.filter);
                this.context = null;
            }
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                        SecurityUtil.remove(this.filter);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                    }
                } else {
                    this.filter.destroy();
                }
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }
}

