/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;

public class ApplicationRequest
extends ServletRequestWrapper {
    private static final HashSet specials = new HashSet(10);
    protected HashMap attributes = new HashMap();
    protected DispatcherType dispatcherType;
    protected static final StringManager sm;

    public ApplicationRequest(ServletRequest request, DispatcherType dispatcherType) {
        super(request);
        this.dispatcherType = dispatcherType;
        this.setRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(this.attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
            if (!ApplicationRequest.isSpecial(name)) {
                this.getRequest().removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
            if (!ApplicationRequest.isSpecial(name)) {
                this.getRequest().setAttribute(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.clear();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object value = request.getAttribute(name);
                this.attributes.put(name, value);
            }
        }
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    protected static boolean isSpecial(String name) {
        return specials.contains(name);
    }

    static {
        specials.add("javax.servlet.include.request_uri");
        specials.add("javax.servlet.include.context_path");
        specials.add("javax.servlet.include.servlet_path");
        specials.add("javax.servlet.include.path_info");
        specials.add("javax.servlet.include.query_string");
        specials.add("javax.servlet.forward.request_uri");
        specials.add("javax.servlet.forward.context_path");
        specials.add("javax.servlet.forward.servlet_path");
        specials.add("javax.servlet.forward.path_info");
        specials.add("javax.servlet.forward.query_string");
        specials.add("javax.servlet.async.request_uri");
        specials.add("javax.servlet.async.context_path");
        specials.add("javax.servlet.async.servlet_path");
        specials.add("javax.servlet.async.path_info");
        specials.add("javax.servlet.async.query_string");
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

