/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterRegistrationImpl
implements FilterRegistration {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private FilterDef filterDef;
    private StandardContext ctx;
    private boolean isProgrammatic;

    FilterRegistrationImpl(FilterDef filterDef, StandardContext ctx, boolean isProgrammatic) {
        this.filterDef = filterDef;
        this.ctx = ctx;
        this.isProgrammatic = isProgrammatic;
    }

    @Override
    public boolean setDescription(String description) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"description", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (!this.isProgrammatic) {
            return false;
        }
        this.filterDef.setDescription(description);
        return true;
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"init parameter", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        return this.filterDef.setInitParameter(name, value, false);
    }

    @Override
    public boolean setInitParameters(Map<String, String> initParameters) {
        return this.filterDef.setInitParameters(initParameters);
    }

    @Override
    public boolean setInitAttribute(String name, Object value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"init attribute", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        return this.filterDef.setInitAttribute(name, value);
    }

    @Override
    public boolean setInitAttributes(Map<String, Object> initAttributes) {
        return this.filterDef.setInitAttributes(initAttributes);
    }

    @Override
    public boolean setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"async-supported", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (!this.isProgrammatic) {
            return false;
        }
        this.filterDef.setIsAsyncSupported(isAsyncSupported);
        return true;
    }

    @Override
    public boolean addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"servlet-name mapping", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (servletNames == null || servletNames.length == 0) {
            throw new IllegalArgumentException(sm.getString("filterRegistration.mappingWithNullOrEmptyServletNames", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        for (String servletName : servletNames) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
        return true;
    }

    @Override
    public boolean addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("filterRegistration.alreadyInitialized", (Object)"url-pattern mapping", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("filterRegistration.mappingWithNullOrEmptyUrlPatterns", (Object)this.filterDef.getFilterName(), this.ctx.getName()));
        }
        for (String urlPattern : urlPatterns) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.filterDef.getFilterName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
        return true;
    }
}

