/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Map;
import javax.servlet.ServletRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRegistrationImpl
implements ServletRegistration {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private StandardWrapper wrapper;
    private StandardContext ctx;
    private boolean isProgrammatic;

    ServletRegistrationImpl(StandardWrapper wrapper, StandardContext ctx, boolean isProgrammatic) {
        this.wrapper = wrapper;
        this.ctx = ctx;
        this.isProgrammatic = isProgrammatic;
    }

    @Override
    public boolean setDescription(String description) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"description", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        if (!this.isProgrammatic) {
            return false;
        }
        this.wrapper.setDescription(description);
        return true;
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"init parameter", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        return this.wrapper.setInitParameter(name, value, false);
    }

    @Override
    public boolean setInitParameters(Map<String, String> initParameters) {
        return this.wrapper.setInitParameters(initParameters);
    }

    @Override
    public boolean setInitAttribute(String name, Object value) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"init attribute", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        return this.wrapper.setInitAttribute(name, value);
    }

    @Override
    public boolean setInitAttributes(Map<String, Object> initAttributes) {
        return this.wrapper.setInitAttributes(initAttributes);
    }

    @Override
    public boolean setLoadOnStartup(int loadOnStartup) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"load-on-startup", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        if (!this.isProgrammatic) {
            return false;
        }
        this.wrapper.setLoadOnStartup(loadOnStartup);
        return true;
    }

    @Override
    public boolean setAsyncSupported(boolean isAsyncSupported) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"async-supported", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        if (!this.isProgrammatic) {
            return false;
        }
        this.wrapper.setIsAsyncSupported(isAsyncSupported);
        return true;
    }

    @Override
    public boolean addMapping(String ... urlPatterns) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(sm.getString("servletRegistration.alreadyInitialized", (Object)"mapping", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("servletRegistration.mappingWithNullOrEmptyUrlPatterns", (Object)this.wrapper.getName(), this.ctx.getName()));
        }
        for (String urlPattern : urlPatterns) {
            this.ctx.addServletMapping(urlPattern, this.wrapper.getName());
        }
        return true;
    }
}

