/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.SerialContextProviderImpl;
import com.sun.enterprise.naming.impl.TransientContext;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class RemoteSerialContextProviderImpl
extends SerialContextProviderImpl {
    public static final String SERIAL_CONTEXT_PROVIDER_NAME = "SerialContextProvider";
    private ORB orb;

    private RemoteSerialContextProviderImpl(ORB orb, TransientContext rootContext) throws RemoteException {
        super(rootContext);
        this.orb = orb;
        PortableRemoteObject.exportObject((Remote)this);
    }

    public static void initSerialContextProvider(ORB orb, TransientContext rootContext) throws RemoteException {
        try {
            RemoteSerialContextProviderImpl impl = new RemoteSerialContextProviderImpl(orb, rootContext);
            Tie servantsTie = Util.getTie((Remote)impl);
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            Policy[] policy = new Policy[]{rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
            POA poa = rootPOA.create_POA("SerialContextProviderPOA", null, policy);
            poa.the_POAManager().activate();
            Object provider = poa.servant_to_reference((Servant)servantsTie);
            Object objRef = orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent nc = new NameComponent(SERIAL_CONTEXT_PROVIDER_NAME, "");
            NameComponent[] path = new NameComponent[]{nc};
            ncRef.rebind(path, provider);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_naming.excep_in_insertserialcontextprovider", ex);
            RemoteException re = new RemoteException("initSerialCtxProvider error");
            re.initCause(ex);
            throw re;
        }
    }

    public java.lang.Object lookup(String name) throws NamingException, RemoteException {
        java.lang.Object obj = super.lookup(name);
        try {
            Reference ref;
            if (obj instanceof Reference && (ref = (Reference)obj).getFactoryClassName().equals("com.sun.enterprise.naming.util.IIOPObjectFactory")) {
                Hashtable<String, ORB> env = new Hashtable<String, ORB>();
                env.put("java.naming.corba.orb", this.orb);
                obj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, env);
            }
        }
        catch (Exception e) {
            RemoteException re = new RemoteException("", e);
            throw re;
        }
        return obj;
    }
}

