/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.NamedNamingObjectManager;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContextProvider;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SerialContext
implements Context {
    private static final String JAVA_URL = "java:";
    private static final String JAVA_GLOBAL_URL = "java:global";
    static final String INITIAL_CONTEXT_TEST_MODE = "com.sun.enterprise.naming.TestMode";
    private static Logger _logger = LogFacade.getLogger();
    private static final NameParser myParser = new SerialNameParser();
    private Hashtable myEnv = null;
    private SerialContextProvider provider;
    private final String myName;
    private final JavaURLContext javaUrlContext;
    private static final Boolean threadlock = new Boolean(true);
    private final Habitat habitat;
    private boolean testMode = false;
    private boolean inClient = false;

    public SerialContext(String name, Hashtable environment, Habitat habitat) throws NamingException {
        this.habitat = habitat;
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.myName = name;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> SerialContext instance created : " + this);
        }
        JavaURLContext urlContextTemp = null;
        urlContextTemp = this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null ? new JavaURLContext(this.myEnv, this) : new JavaURLContext(this.myEnv, null);
        this.javaUrlContext = urlContextTemp;
        if (this.myEnv.get(INITIAL_CONTEXT_TEST_MODE) != null) {
            this.testMode = true;
            System.out.println("SerialContext in test mode");
        }
        if (habitat == null && !this.testMode) {
            this.inClient = true;
            System.out.println("SerialContext in client mode");
        }
    }

    public SerialContext(Hashtable env, Habitat habitat) throws NamingException {
        this("", env, habitat);
    }

    private SerialContextProvider getProvider() throws NamingException {
        if (this.provider == null) {
            try {
                this.provider = this.inClient ? this.getRemoteProvider() : ProviderManager.getProviderManager().getLocalProvider();
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Unable to acquire SerialContextProvider");
                ne.initCause(e);
                throw ne;
            }
        }
        return this.provider;
    }

    private SerialContextProvider getRemoteProvider() throws Exception {
        String host = "localhost";
        String port = "3700";
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialContextProvider narrowProvider(Object ref) throws Exception {
        NamingContext nctx = NamingContextHelper.narrow((Object)ref);
        NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
        Boolean bl = threadlock;
        synchronized (bl) {
            this.provider = (SerialContextProvider)PortableRemoteObject.narrow((java.lang.Object)nctx.resolve(path), SerialContextProvider.class);
        }
        return this.provider;
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }

    private boolean isjavaURL(String name) {
        return name.startsWith(JAVA_URL) && !name.startsWith(JAVA_GLOBAL_URL);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        NamedNamingObjectManager.checkAndLoadProxies(this.habitat);
        if (this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null) {
            // empty if block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> lookup( " + name + ")");
        }
        if (name.equals("")) {
            return new SerialContext(this.myName, this.myEnv, this.habitat);
        }
        name = this.getRelativeName(name);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> lookup relative name : " + name);
        }
        try {
            if (this.isjavaURL(name)) {
                return this.javaUrlContext.lookup(name);
            }
            java.lang.Object obj = this.getProvider().lookup(name);
            if (obj instanceof NamingObjectProxy) {
                return ((NamingObjectProxy)obj).create((Context)this);
            }
            if (obj instanceof Context) {
                return new SerialContext(name, this.myEnv, this.habitat);
            }
            java.lang.Object retObj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, this.myEnv);
            return retObj;
        }
        catch (NamingException nnfe) {
            throw nnfe;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_naming.serialctx_communication_exception", ex);
            if (ex instanceof MarshalException && ex.getCause() instanceof COMM_FAILURE) {
                this.provider = null;
                _logger.fine("Resetting provider to NULL. Will get new obj ref for provider since previous obj ref was stale...");
                return this.lookup(name);
            }
            CommunicationException ce = new CommunicationException("serial context communication ex");
            ce.initCause(ex);
            throw ce;
        }
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.bind(name, obj);
        } else {
            try {
                this.getProvider().bind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.rebind(name, obj);
        } else {
            try {
                this.getProvider().rebind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.unbind(name);
        } else {
            try {
                this.getProvider().unbind(name);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        if (this.isjavaURL(oldname)) {
            this.javaUrlContext.rename(oldname, newname);
        } else {
            try {
                this.getProvider().rename(oldname, newname);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepNames(bindings);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.list(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepBindings(bindings);
            }
            catch (RemoteException ex) {
                CommunicationException ce = new CommunicationException(ex.toString());
                ce.initCause(ex);
                throw ce;
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.listBindings(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.destroySubcontext(name);
        } else {
            try {
                this.getProvider().destroySubcontext(name);
            }
            catch (RemoteException e) {
                CommunicationException ce = new CommunicationException(e.toString());
                ce.initCause(e);
                throw ce;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c = null;
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.createSubcontext(name);
        }
        try {
            c = this.getProvider().createSubcontext(name);
            if (c instanceof Context) {
                c = new SerialContext(name, this.myEnv, this.habitat);
            }
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException(e.toString());
            ce.initCause(e);
            throw ce;
        }
        return c;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.lookupLink(name);
        }
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String name) {
        if (!this.myName.equals("")) {
            name = this.myName + "/" + name;
        }
        return name;
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

