/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.UnifiedX509TrustManager;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public final class SSLUtils
implements PostConstruct {
    private static final String DEFAULT_KEYSTORE_PASS = "changeit";
    private static final String DEFAULT_TRUSTSTORE_PASS = "changeit";
    private static final String KEYSTORE_PASS_PROP = "javax.net.ssl.keyStorePassword";
    private static final String TRUSTSTORE_PASS_PROP = "javax.net.ssl.trustStorePassword";
    private static final String DEFAULT_OUTBOUND_KEY_ALIAS = "s1as";
    public static final String HTTPS_OUTBOUND_KEY_ALIAS = "com.sun.enterprise.security.httpsOutboundKeyAlias";
    private static final Logger _logger = LogDomains.getLogger(SSLUtils.class, (String)"javax.enterprise.system.core.security");
    @Inject
    SecuritySupport secSupp;
    @Inject
    Habitat habitat;
    private boolean hasKey = false;
    private KeyManager keyManager = null;
    private TrustManager trustManager = null;
    private KeyStore mergedTrustStore = null;
    private Date initDate;

    public void postConstruct() {
        try {
            this.initDate = new Date();
            KeyStore[] keyStores = this.getKeyStores();
            this.initKeyManagers(keyStores, this.secSupp.getKeyStorePasswords());
            this.initTrustManagers(this.getTrustStores());
            if (keyStores != null) {
                for (KeyStore keyStore : keyStores) {
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!keyStore.isKeyEntry(alias)) continue;
                        this.hasKey = true;
                        break;
                    }
                    if (this.hasKey) break;
                }
            }
            this.mergedTrustStore = this.mergingTrustStores(this.secSupp.getTrustStores());
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "SSLUtils static init fails.", ex);
            }
            throw new IllegalStateException(ex);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            String keyAlias = System.getProperty(HTTPS_OUTBOUND_KEY_ALIAS, DEFAULT_OUTBOUND_KEY_ALIAS);
            KeyManager[] kMgrs = this.getKeyManagers();
            if (keyAlias != null && keyAlias.length() > 0 && kMgrs != null) {
                for (int i = 0; i < kMgrs.length; ++i) {
                    kMgrs[i] = new J2EEKeyManager(this.habitat, (X509KeyManager)kMgrs[i], keyAlias);
                }
            }
            ctx.init(kMgrs, this.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public KeyStore[] getKeyStores() throws Exception {
        return this.secSupp.getKeyStores();
    }

    public KeyStore getKeyStore() throws Exception {
        return this.getKeyStores()[0];
    }

    public KeyStore[] getTrustStores() throws Exception {
        return this.secSupp.getTrustStores();
    }

    public KeyStore getTrustStore() throws Exception {
        return this.getTrustStores()[0];
    }

    public KeyStore getMergedTrustStore() {
        return this.mergedTrustStore;
    }

    public KeyManager[] getKeyManagers() throws Exception {
        return new KeyManager[]{this.keyManager};
    }

    public TrustManager[] getTrustManagers() throws Exception {
        return new TrustManager[]{this.trustManager};
    }

    public static String getKeyStorePass() {
        return System.getProperty(KEYSTORE_PASS_PROP, "changeit");
    }

    public static String getTrustStorePass() {
        return System.getProperty(TRUSTSTORE_PASS_PROP, "changeit");
    }

    public boolean isKeyAvailable() {
        return this.hasKey;
    }

    public boolean isTokenKeyAlias(String certNickname) throws Exception {
        boolean isTokenKeyAlias = false;
        if (certNickname != null) {
            int ind = certNickname.indexOf(58);
            KeyStore[] kstores = this.getKeyStores();
            int count = -1;
            String aliasName = null;
            if (ind != -1) {
                String[] tokens = this.secSupp.getTokenNames();
                String tokenName = certNickname.substring(0, ind);
                aliasName = certNickname.substring(ind + 1);
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokenName.equals(tokens[i])) continue;
                    count = i;
                }
            }
            if (count != -1) {
                isTokenKeyAlias = kstores[count].isKeyEntry(aliasName);
            } else {
                for (KeyStore kstore : kstores) {
                    if (!kstore.isKeyEntry(certNickname)) continue;
                    isTokenKeyAlias = true;
                    break;
                }
            }
        }
        return isTokenKeyAlias;
    }

    public KeyStore.PrivateKeyEntry getPrivateKeyEntryFromTokenAlias(String certNickname) throws Exception {
        KeyStore.PrivateKeyEntry privKeyEntry;
        block3: {
            String[] passwords;
            String aliasName;
            KeyStore[] kstores;
            block4: {
                privKeyEntry = null;
                if (certNickname == null) break block3;
                int ind = certNickname.indexOf(58);
                kstores = this.getKeyStores();
                int count = -1;
                aliasName = certNickname;
                if (ind != -1) {
                    String[] tokens = this.secSupp.getTokenNames();
                    String tokenName = certNickname.substring(0, ind);
                    aliasName = certNickname.substring(ind + 1);
                    for (int i = 0; i < tokens.length; ++i) {
                        if (!tokenName.equals(tokens[i])) continue;
                        count = i;
                    }
                }
                passwords = this.secSupp.getKeyStorePasswords();
                if (count == -1 || passwords.length < count) break block4;
                Key key = kstores[count].getKey(aliasName, passwords[count].toCharArray());
                if (!(key instanceof PrivateKey)) break block3;
                PrivateKey privKey = (PrivateKey)key;
                Certificate[] certs = kstores[count].getCertificateChain(aliasName);
                privKeyEntry = new KeyStore.PrivateKeyEntry(privKey, certs);
                break block3;
            }
            for (int i = 0; i < kstores.length; ++i) {
                Key key = kstores[i].getKey(aliasName, passwords[i].toCharArray());
                if (key == null || !(key instanceof PrivateKey)) continue;
                PrivateKey privKey = (PrivateKey)key;
                Certificate[] certs = kstores[i].getCertificateChain(aliasName);
                privKeyEntry = new KeyStore.PrivateKeyEntry(privKey, certs);
                break;
            }
        }
        return privKeyEntry;
    }

    public SecuritySupport getSecuritySupport() {
        return this.secSupp;
    }

    public String[] getSupportedCipherSuites() {
        return HttpsURLConnection.getDefaultSSLSocketFactory().getSupportedCipherSuites();
    }

    private void initKeyManagers(KeyStore[] kstores, String[] pwds) throws Exception {
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < kstores.length; ++i) {
            this.checkCertificateDates(kstores[i]);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(kstores[i], pwds[i].toCharArray());
            KeyManager[] kmgrs = kmf.getKeyManagers();
            if (kmgrs == null) continue;
            keyManagers.addAll(Arrays.asList(kmgrs));
        }
        this.keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), this.secSupp.getTokenNames());
    }

    private void initTrustManagers(KeyStore[] tstores) throws Exception {
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (KeyStore tstore : tstores) {
            this.checkCertificateDates(tstore);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(tstore);
            TrustManager[] tmgrs = tmf.getTrustManagers();
            if (tmgrs == null) continue;
            trustManagers.addAll(Arrays.asList(tmgrs));
        }
        this.trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
    }

    private KeyStore mergingTrustStores(KeyStore[] trustStores) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore mergedStore;
        try {
            mergedStore = KeyStore.getInstance("CaseExactJKS");
        }
        catch (KeyStoreException ex) {
            mergedStore = KeyStore.getInstance("JKS");
        }
        String[] passwords = this.secSupp.getKeyStorePasswords();
        mergedStore.load(null, passwords[passwords.length - 1].toCharArray());
        String[] tokens = this.secSupp.getTokenNames();
        for (int i = 0; i < trustStores.length; ++i) {
            Enumeration<String> aliases = trustStores[i].aliases();
            while (aliases.hasMoreElements()) {
                Certificate aCert;
                String alias2;
                String alias = aliases.nextElement();
                Certificate cert = trustStores[i].getCertificate(alias);
                String alias3 = alias2 = i < tokens.length - 1 ? tokens[i] + ":" + alias : alias;
                boolean alreadyInStore = false;
                int count = 1;
                while ((aCert = mergedStore.getCertificate(alias3)) != null) {
                    if (aCert.equals(cert)) {
                        alreadyInStore = true;
                        break;
                    }
                    alias3 = alias2 + "__" + count++;
                }
                if (alreadyInStore) continue;
                mergedStore.setCertificateEntry(alias3, cert);
            }
        }
        return mergedStore;
    }

    private void checkCertificateDates(KeyStore store) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            Certificate cert = store.getCertificate(aliases.nextElement());
            if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getNotAfter().before(this.initDate)) continue;
            _logger.log(Level.SEVERE, "java_security.expired_certificate", cert);
        }
    }
}

