/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public final class Transactions
implements PostConstruct,
PreDestroy {
    private final List<ListenerNotifier<TransactionListener, ?, Void>> listeners = new ArrayList();
    @Inject(name="transactions-executor", optional=true)
    private ExecutorService executor;
    private final ConfigListenerNotifier configListenerNotifier = new ConfigListenerNotifier();

    public void postConstruct() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        this.configListenerNotifier.start();
    }

    public void preDestroy() {
        for (ListenerNotifier<TransactionListener, ?, Void> listener : this.listeners) {
            listener.stop();
        }
        this.configListenerNotifier.stop();
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionsListener(TransactionListener listener) {
        List<ListenerNotifier<TransactionListener, ?, Void>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ListenerNotifier(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransactionsListener(TransactionListener listener) {
        List<ListenerNotifier<TransactionListener, ?, Void>> list = this.listeners;
        synchronized (list) {
            for (ListenerNotifier<TransactionListener, ?, Void> info : this.listeners) {
                if (info.listener != listener) continue;
                info.stop();
                return this.listeners.remove(info);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionListener> currentListeners() {
        List<ListenerNotifier<TransactionListener, ?, Void>> list = this.listeners;
        synchronized (list) {
            ArrayList<TransactionListener> l = new ArrayList<TransactionListener>();
            for (ListenerNotifier<TransactionListener, ?, Void> info : this.listeners) {
                l.add((TransactionListener)info.listener);
            }
            return l;
        }
    }

    void addTransaction(List<PropertyChangeEvent> events) {
        this.addTransaction(events, true);
    }

    void addTransaction(List<PropertyChangeEvent> events, boolean waitTillCleared) {
        ArrayList listInfos = new ArrayList();
        listInfos.addAll(this.listeners);
        TransactionListenerJob job = new TransactionListenerJob(events, waitTillCleared ? new CountDownLatch(listInfos.size()) : null);
        ConfigListenerJob configJob = new ConfigListenerJob(events, waitTillCleared ? new CountDownLatch(1) : null);
        try {
            for (ListenerNotifier listenerNotifier : listInfos) {
                listenerNotifier.add((Job)job);
            }
            this.configListenerNotifier.add((Job)configJob);
            job.waitForLatch();
            configJob.waitForLatch();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForDrain() {
        this.addTransaction(new ArrayList<PropertyChangeEvent>(), true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigListenerJob
    extends Job<ConfigListener, PropertyChangeEvent, UnprocessedChangeEvents> {
        final PropertyChangeEvent[] eventsArray;

        public ConfigListenerJob(List<PropertyChangeEvent> events, CountDownLatch latch) {
            super(events, latch);
            this.eventsArray = this.mEvents.toArray(new PropertyChangeEvent[this.mEvents.size()]);
        }

        @Override
        public UnprocessedChangeEvents process(ConfigListener target) {
            return target.changed(this.eventsArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnprocessedEventsJob
    extends Job<TransactionListener, UnprocessedChangeEvents, Void> {
        public UnprocessedEventsJob(List<UnprocessedChangeEvents> events, CountDownLatch latch) {
            super(events, latch);
        }

        @Override
        public Void process(TransactionListener listener) {
            try {
                listener.unprocessedTransactedEvents(this.mEvents);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionListenerJob
    extends Job<TransactionListener, PropertyChangeEvent, Void> {
        public TransactionListenerJob(List<PropertyChangeEvent> events, CountDownLatch latch) {
            super(events, latch);
        }

        @Override
        public Void process(TransactionListener listener) {
            try {
                listener.transactionCommited(this.mEvents);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Job<T, U, V> {
        private final CountDownLatch mLatch;
        protected final List<U> mEvents;

        public Job(List<U> events, CountDownLatch latch) {
            this.mLatch = latch;
            this.mEvents = events;
        }

        public void waitForLatch() throws InterruptedException {
            if (this.mLatch != null) {
                this.mLatch.await();
            }
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }

        public abstract V process(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigListenerNotifier
    extends Notifier<ConfigListener, PropertyChangeEvent, UnprocessedChangeEvents> {
        @Override
        protected FutureTask<UnprocessedChangeEvents> prepare(final Job<ConfigListener, PropertyChangeEvent, UnprocessedChangeEvents> job) {
            final HashSet<ConfigListener> configListeners = new HashSet<ConfigListener>();
            for (PropertyChangeEvent event : job.mEvents) {
                Dom dom = (Dom)((Object)((ConfigView)Proxy.getInvocationHandler(event.getSource())).getMasterView());
                configListeners.addAll(dom.getListeners());
                if (dom.parent() == null) continue;
                configListeners.addAll(dom.parent().getListeners());
            }
            return new FutureTask<UnprocessedChangeEvents>(new Callable<UnprocessedChangeEvents>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public UnprocessedChangeEvents call() throws Exception {
                    try {
                        ArrayList<Future<UnprocessedChangeEvents>> futures = new ArrayList<Future<UnprocessedChangeEvents>>();
                        for (final ConfigListener listener : configListeners) {
                            futures.add(Transactions.this.executor.submit(new Callable<UnprocessedChangeEvents>(){

                                @Override
                                public UnprocessedChangeEvents call() throws Exception {
                                    return (UnprocessedChangeEvents)job.process(listener);
                                }
                            }));
                        }
                        ArrayList<UnprocessedChangeEvents> unprocessed = new ArrayList<UnprocessedChangeEvents>(futures.size());
                        for (Future future : futures) {
                            try {
                                UnprocessedChangeEvents result = (UnprocessedChangeEvents)future.get(200L, TimeUnit.SECONDS);
                                if (result.getUnprocessed() == null || result.getUnprocessed().size() <= 0) continue;
                                for (UnprocessedChangeEvent event : result.getUnprocessed()) {
                                    Logger.getAnonymousLogger().log(Level.WARNING, "Unprocessed event : " + event);
                                }
                                unprocessed.add(result);
                            }
                            catch (InterruptedException e) {
                                Logger.getAnonymousLogger().log(Level.SEVERE, "Config Listener notification got interruped", e);
                            }
                            catch (ExecutionException e) {
                                Logger.getAnonymousLogger().log(Level.SEVERE, "Config Listener notification got interruped", e);
                            }
                            catch (TimeoutException e) {
                                Logger.getAnonymousLogger().log(Level.SEVERE, "Config Listener notification took too long", e);
                            }
                        }
                        if (!unprocessed.isEmpty()) {
                            UnprocessedEventsJob unprocessedJob = new UnprocessedEventsJob((List<UnprocessedChangeEvents>)unprocessed, null);
                            for (ListenerNotifier listener : Transactions.this.listeners) {
                                listener.add((Job)unprocessedJob);
                            }
                        }
                    }
                    finally {
                        job.releaseLatch();
                    }
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListenerNotifier<T, U, V>
    extends Notifier<T, U, V> {
        final T listener;

        public ListenerNotifier(T listener) {
            this.listener = listener;
            this.start();
        }

        @Override
        protected FutureTask<V> prepare(final Job<T, U, V> job) {
            return new FutureTask(new Callable<V>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V call() throws Exception {
                    try {
                        if (job.mEvents.size() != 0) {
                            Object v = job.process(ListenerNotifier.this.listener);
                            return v;
                        }
                    }
                    finally {
                        job.releaseLatch();
                    }
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Notifier<T, U, V> {
        private final BlockingQueue<FutureTask> pendingJobs = new ArrayBlockingQueue<FutureTask>(50);
        private CountDownLatch latch = new CountDownLatch(1);

        private Notifier() {
        }

        protected abstract FutureTask<V> prepare(Job<T, U, V> var1);

        public Future<V> add(Job<T, U, V> job) {
            if (this.latch.getCount() == 0L) {
                throw new RuntimeException("TransactionListener is inactive, yet jobs are published to it");
            }
            try {
                this.pendingJobs.put(this.prepare(job));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        protected void start() {
            Transactions.this.executor.submit(new Runnable(){

                public void run() {
                    while (Notifier.this.latch.getCount() > 0L) {
                        try {
                            FutureTask job = (FutureTask)Notifier.this.pendingJobs.take();
                            job.run();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }

        void stop() {
            this.latch.countDown();
            this.pendingJobs.add(this.prepare(new Job<T, U, V>(null, null){

                @Override
                public V process(T target) {
                    return null;
                }
            }));
        }
    }
}

