/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.internal.ModifiableClassLogger;
import com.sun.jdmk.internal.ThreadService;
import com.sun.management.comm.CommunicatorServer;
import com.sun.management.comm.SnmpAdaptorServerMBean;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpRequestHandler;
import com.sun.management.comm.SnmpSession;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.snmp.IPAcl.JdmkAcl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpMessage;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduFactoryBER;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpErrorHandlerAgent;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibHandler;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpPeer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpAdaptorServer
extends CommunicatorServer
implements SnmpAdaptorServerMBean,
MBeanRegistration,
SnmpDefinitions,
SnmpMibHandler {
    private int trapPort;
    private int informPort;
    InetAddress address;
    private Object ipacl;
    private SnmpPduFactory pduFactory;
    private SnmpUserDataFactory userDataFactory;
    private boolean authRespEnabled;
    private boolean authTrapEnabled;
    private SnmpOid enterpriseOid;
    int bufferSize;
    private transient long startUpTime;
    private volatile transient DatagramSocket socket;
    transient DatagramSocket trapSocket;
    private transient SnmpSession informSession;
    private transient DatagramPacket packet;
    transient Vector mibs;
    private transient SnmpMibTree root;
    private transient boolean useAcl;
    private int maxTries;
    private int timeout;
    int snmpOutTraps;
    private int snmpOutGetResponses;
    private int snmpOutGenErrs;
    private int snmpOutBadValues;
    private int snmpOutNoSuchNames;
    private int snmpOutTooBigs;
    int snmpOutPkts;
    private int snmpInASNParseErrs;
    private int snmpInBadCommunityUses;
    private int snmpInBadCommunityNames;
    private int snmpInBadVersions;
    private int snmpInGetRequests;
    private int snmpInGetNexts;
    private int snmpInSetRequests;
    private int snmpInPkts;
    private int snmpInTotalReqVars;
    private int snmpInTotalSetVars;
    private int snmpSilentDrops;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private ThreadService threadService;
    private static int threadNumber = 6;
    private static final String THREAD_NUMBER_PROPERTY = "com.sun.management.snmp.threadnumber";
    private SnmpMibAgent defaultAgent;

    public SnmpAdaptorServer() {
        this(null, 161, null);
    }

    public SnmpAdaptorServer(int port) {
        this(null, port, null);
    }

    public SnmpAdaptorServer(InetAddressAcl acl) {
        this(acl, 161, null);
    }

    public SnmpAdaptorServer(InetAddress addr) {
        this(null, 161, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, int port) {
        this(acl, port, null);
    }

    public SnmpAdaptorServer(int port, InetAddress addr) {
        this(null, port, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, InetAddress addr) {
        this(acl, 161, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, int port, InetAddress addr) {
        block3: {
            super(4);
            this.trapPort = 162;
            this.informPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.userDataFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.informSession = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.maxTries = 3;
            this.timeout = 3000;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            this.snmpSilentDrops = 0;
            this.defaultAgent = null;
            if (acl == null) {
                try {
                    acl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException e) {
                    if (!this.logger.finestOn()) break block3;
                    this.logger.finest("constructor", "UnknowHostException when creating ACL");
                    this.logger.finest("constructor", e);
                }
            }
        }
        this.init(acl, port, addr);
    }

    public SnmpAdaptorServer(boolean useAcl, int port, InetAddress addr) {
        JdmkAcl acl;
        block3: {
            super(4);
            this.trapPort = 162;
            this.informPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.userDataFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.informSession = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.maxTries = 3;
            this.timeout = 3000;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            this.snmpSilentDrops = 0;
            this.defaultAgent = null;
            this.useAcl = useAcl;
            acl = null;
            if (useAcl) {
                try {
                    acl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException e) {
                    if (!this.logger.finestOn()) break block3;
                    this.logger.finest("constructor", "UnknowHostException when creating ACL");
                    this.logger.finest("constructor", e);
                }
            }
        }
        this.init(acl, port, addr);
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public void setMaxActiveClientCount(int c) throws IllegalStateException {
        super.setMaxActiveClientCount(c);
    }

    public InetAddressAcl getInetAddressAcl() {
        return (InetAddressAcl)this.ipacl;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    public void setTrapPort(Integer port) {
        int val = port;
        if (val < 0) {
            throw new IllegalArgumentException("Trap port cannot be a negative value");
        }
        this.trapPort = val;
    }

    public int getInformPort() {
        return this.informPort;
    }

    public void setInformPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Inform request port cannot be a negative value");
        }
        this.informPort = port;
    }

    public String getProtocol() {
        return "snmp";
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public void setBufferSize(Integer s) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.bufferSize = s;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int newMaxTries) {
        if (newMaxTries < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = newMaxTries;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int newTimeout) {
        if (newTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = newTimeout;
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory factory) {
        this.pduFactory = factory == null ? new SnmpPduFactoryBER() : factory;
    }

    public void setUserDataFactory(SnmpUserDataFactory factory) {
        this.userDataFactory = factory;
    }

    public SnmpUserDataFactory getUserDataFactory() {
        return this.userDataFactory;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public void setAuthTrapEnabled(boolean enabled) {
        this.authTrapEnabled = enabled;
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public void setAuthRespEnabled(boolean enabled) {
        this.authRespEnabled = enabled;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public void setEnterpriseOid(String oid) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(oid);
    }

    public String[] getMibs() {
        String[] result = new String[this.mibs.size()];
        int i = 0;
        Enumeration e = this.mibs.elements();
        while (e.hasMoreElements()) {
            SnmpMibAgent mib = (SnmpMibAgent)e.nextElement();
            result[i++] = mib.getMibName();
        }
        return result;
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpSilentDrops() {
        return new Long(this.snmpSilentDrops);
    }

    public Long getSnmpProxyDrops() {
        return new Long(0L);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + "name=SnmpAdaptorServer");
        }
        return super.preRegister(server, name);
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + mib + "]");
        }
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (!this.mibs.contains(mib)) {
            this.mibs.addElement(mib);
        }
        this.root.register(mib);
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, SnmpOid[] oids) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + mib + "]");
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < oids.length; ++i) {
                b.append(oids[i] + " ");
            }
            this.logger.finer("addMib", "Oid[] = " + b.toString());
        }
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (oids == null || oids.length == 0) {
            return this.addMib(mib);
        }
        if (!this.mibs.contains(mib)) {
            this.mibs.addElement(mib);
        }
        for (int i = 0; i < oids.length; ++i) {
            this.root.register(mib, oids[i].longValue());
        }
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName) throws IllegalArgumentException {
        return this.addMib(mib);
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) throws IllegalArgumentException {
        return this.addMib(mib, oids);
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName) {
        return this.removeMib(mib);
    }

    public boolean removeMib(SnmpMibAgent mib) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [ " + mib + "]");
        }
        this.root.unregister(mib);
        return this.mibs.removeElement(mib);
    }

    public boolean removeMib(SnmpMibAgent mib, SnmpOid[] oids) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [" + mib + "]");
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < oids.length; ++i) {
                b.append(oids[i] + " ");
            }
            this.logger.finer("removeMib", "Oid[] = " + b.toString());
        }
        if (oids == null || oids.length == 0) {
            return this.removeMib(mib);
        }
        boolean ret = this.mibs.contains(mib);
        if (ret) {
            this.root.unregister(mib, oids);
            if (!this.root.isMibReferenced(mib)) {
                if (this.logger.finerOn()) {
                    this.logger.finer("removeMib", "Mib removed");
                }
                this.mibs.removeElement(mib);
            } else if (this.logger.finerOn()) {
                this.logger.finer("removeMib", "Mib NOT removed, still referenced");
            }
        }
        return ret;
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) {
        return this.removeMib(mib, oids);
    }

    public void setPort(int port) throws IllegalStateException {
        super.setPort(port);
        this.updateLogger();
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            this.socket = new DatagramSocket(this.port, this.address);
            this.updateLogger();
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            if (this.logger.finestOn()) {
                this.logger.finest("doBind", "cannot bind on port " + this.port);
            }
            throw new CommunicationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doUnbind", "Finally close the socket");
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        finally {
            this.closeTrapSocketIfNeeded();
            this.closeInformSocketIfNeeded();
        }
    }

    void createSnmpRequestHandler(SnmpAdaptorServer server, int id, DatagramSocket s, DatagramPacket p, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        SnmpRequestHandler handler = new SnmpRequestHandler(this, id, s, p, tree, m, a, factory, dataFactory, f, n);
        this.threadService.submitTask(handler);
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            int state = this.getState();
            if (state != 0) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doReceive", "received a message but state not online, reruning.");
                }
                return;
            }
            this.createSnmpRequestHandler(this, this.servedClientCount, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.userDataFactory, this.topMBS, this.objectName);
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.toString());
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("doReceive", "received a message");
        }
    }

    protected void doError(Exception e) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    public void stop() {
        block6: {
            InetAddress address = this.getAddress();
            int port = this.getPort();
            if (this.state == 0 || this.state == 3) {
                if (this.logger.finerOn()) {
                    this.logger.finer("stop", "Stopping: using port " + port);
                }
                super.stop();
                try {
                    DatagramSocket sn = new DatagramSocket(0);
                    byte[] ob = new byte[1];
                    DatagramPacket pk = address != null && !address.isAnyLocalAddress() ? new DatagramPacket(ob, 1, address, port) : new DatagramPacket(ob, 1, InetAddress.getLocalHost(), port);
                    if (port > 0) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("stop", "Sending: using port " + port);
                        }
                        sn.send(pk);
                        sn.close();
                    }
                }
                catch (Throwable e) {
                    if (!this.logger.finestOn()) break block6;
                    this.logger.finest("stop", e);
                }
            }
        }
    }

    public void snmpV1Trap(int generic, int specific, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 164;
        pdu.version = 0;
        pdu.community = null;
        pdu.enterprise = this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        try {
            pdu.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException e) {
            byte[] zeroedAddr = new byte[4];
            pdu.agentAddr = this.handleMultipleIpVersion(zeroedAddr);
        }
        this.sendTrapPdu(pdu);
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] address) {
        if (address.length == 4) {
            return new SnmpIpAddress(address);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    public void snmpV1Trap(InetAddress addr, String cs, int generic, int specific, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 164;
        pdu.version = 0;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        pdu.enterprise = this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        try {
            pdu.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException e) {
            byte[] zeroedAddr = new byte[4];
            pdu.agentAddr = this.handleMultipleIpVersion(zeroedAddr);
        }
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV1Trap(InetAddress addr, SnmpIpAddress agentAddr, String cs, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        this.snmpV1Trap(addr, this.trapPort, agentAddr, cs, enterpOid, generic, specific, varBindList, time);
    }

    public void snmpV1Trap(SnmpPeer peer, SnmpIpAddress agentAddr, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        SnmpParameters p = (SnmpParameters)peer.getParams();
        this.snmpV1Trap(peer.getDestAddr(), peer.getDestPort(), agentAddr, p.getRdCommunity(), enterpOid, generic, specific, varBindList, time);
    }

    private void snmpV1Trap(InetAddress addr, int port, SnmpIpAddress agentAddr, String cs, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = port;
        pdu.type = 164;
        pdu.version = 0;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        pdu.enterprise = enterpOid != null ? enterpOid : this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = time != null ? time.longValue() : this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        if (agentAddr != null) {
            pdu.agentAddr = agentAddr;
        } else {
            try {
                pdu.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException e) {
                byte[] zeroedAddr = new byte[4];
                pdu.agentAddr = this.handleMultipleIpVersion(zeroedAddr);
            }
        }
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV2Trap(SnmpPeer peer, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        SnmpParameters p = (SnmpParameters)peer.getParams();
        this.snmpV2Trap(peer.getDestAddr(), peer.getDestPort(), p.getRdCommunity(), trapOid, varBindList, time);
    }

    public void snmpV2Trap(SnmpOid trapOid, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + trapOid);
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 167;
        pdu.version = 1;
        pdu.community = null;
        SnmpVarBindList fullVbl = SnmpAdaptorServer.completeTrapVarBindList(varBindList, trapOid, new SnmpTimeticks(this.getSysUpTime()));
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        this.sendTrapPdu(pdu);
    }

    public void snmpV2Trap(InetAddress addr, String cs, SnmpOid trapOid, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + trapOid);
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 167;
        pdu.version = 1;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        SnmpVarBindList fullVbl = SnmpAdaptorServer.completeTrapVarBindList(varBindList, trapOid, new SnmpTimeticks(this.getSysUpTime()));
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV2Trap(InetAddress addr, String cs, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        this.snmpV2Trap(addr, this.trapPort, cs, trapOid, varBindList, time);
    }

    private void snmpV2Trap(InetAddress addr, int port, String cs, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + trapOid + "\ncommunity=" + cs + "\naddr=" + addr + "\nvarBindList=" + varBindList + "\ntime=" + time + "\ntrapPort=" + port);
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = port;
        pdu.type = 167;
        pdu.version = 1;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        SnmpTimeticks sysUpTimeValue = null;
        sysUpTimeValue = time != null ? time : new SnmpTimeticks(this.getSysUpTime());
        SnmpVarBindList fullVbl = SnmpAdaptorServer.completeTrapVarBindList(varBindList, trapOid, sysUpTimeValue);
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpPduTrap(InetAddress address, SnmpPduPacket pdu) throws IOException, SnmpStatusException {
        if (address != null) {
            this.sendTrapPdu(address, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpPduTrap(SnmpPeer peer, SnmpPduPacket pdu) throws IOException, SnmpStatusException {
        if (peer != null) {
            pdu.port = peer.getDestPort();
            this.sendTrapPdu(peer.getDestAddr(), pdu);
        } else {
            pdu.port = this.getTrapPort();
            this.sendTrapPdu(pdu);
        }
    }

    static SnmpVarBindList completeTrapVarBindList(SnmpVarBindList vbl, SnmpOid notificationOid, SnmpTimeticks sysUpTimeValue) {
        SnmpVarBindList fullVbl = vbl != null ? (SnmpVarBindList)vbl.clone() : new SnmpVarBindList(2);
        int length = fullVbl.size();
        if (length == 0 || !fullVbl.getVarBindAt(0).getOid().equals(sysUpTimeOid)) {
            fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        }
        if (length <= 1 || !fullVbl.getVarBindAt(1).getOid().equals(snmpTrapOidOid)) {
            fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, notificationOid), 1);
        }
        return fullVbl;
    }

    private void sendTrapPdu(SnmpPduPacket pdu) throws SnmpStatusException, IOException {
        block14: {
            SnmpMessage msg = null;
            try {
                msg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(pdu, this.bufferSize);
                if (msg == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to anyone");
                }
                throw new SnmpStatusException(1);
            }
            int sendingCount = 0;
            this.openTrapSocketIfNeeded();
            if (this.ipacl != null) {
                Enumeration ed = ((InetAddressAcl)this.ipacl).getTrapDestinations();
                while (ed.hasMoreElements()) {
                    msg.address = (InetAddress)ed.nextElement();
                    Enumeration ec = ((InetAddressAcl)this.ipacl).getTrapCommunities(msg.address);
                    while (ec.hasMoreElements()) {
                        msg.community = ((String)ec.nextElement()).getBytes();
                        try {
                            this.sendTrapMessage(msg);
                            ++sendingCount;
                        }
                        catch (SnmpTooBigException x) {
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("sendTrapPdu", "trap pdu is too big");
                            this.logger.finest("sendTrapPdu", "trap hasn't been sent to " + msg.address);
                        }
                    }
                }
            }
            if (sendingCount == 0) {
                try {
                    msg.address = InetAddress.getLocalHost();
                    this.sendTrapMessage(msg);
                }
                catch (SnmpTooBigException x) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("sendTrapPdu", "trap pdu is too big");
                        this.logger.finest("sendTrapPdu", "trap hasn't been sent");
                    }
                }
                catch (UnknownHostException e) {
                    if (!this.logger.finestOn()) break block14;
                    this.logger.finest("sendTrapPdu", "cannot get the local host");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent");
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapPdu(InetAddress addr, SnmpPduPacket pdu) throws SnmpStatusException, IOException {
        block7: {
            SnmpMessage msg = null;
            try {
                msg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(pdu, this.bufferSize);
                if (msg == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to the specified host");
                }
                throw new SnmpStatusException(1);
            }
            this.openTrapSocketIfNeeded();
            if (addr != null) {
                msg.address = addr;
                try {
                    this.sendTrapMessage(msg);
                }
                catch (SnmpTooBigException x) {
                    if (!this.logger.finestOn()) break block7;
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to " + msg.address);
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapMessage(SnmpMessage msg) throws IOException, SnmpTooBigException {
        byte[] buffer = new byte[this.bufferSize];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        int encodingLength = msg.encodeMessage(buffer);
        packet.setLength(encodingLength);
        packet.setAddress(msg.address);
        packet.setPort(msg.port);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sending trap to " + msg.address + ":" + msg.port);
        }
        this.trapSocket.send(packet);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sent to " + msg.address + ":" + msg.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket(0, this.address);
            if (this.logger.finerOn()) {
                this.logger.finer("openTrapSocketIfNeeded", "using port " + this.trapSocket.getLocalPort() + " to send traps");
            }
        }
    }

    synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    public Vector snmpInformRequest(SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpInformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? (SnmpVarBindList)varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpInformRequest> informReqList = new Vector<SnmpInformRequest>();
        InetAddress addr = null;
        String cs = null;
        if (this.ipacl != null) {
            Enumeration ed = ((InetAddressAcl)this.ipacl).getInformDestinations();
            while (ed.hasMoreElements()) {
                addr = (InetAddress)ed.nextElement();
                Enumeration ec = ((InetAddressAcl)this.ipacl).getInformCommunities(addr);
                while (ec.hasMoreElements()) {
                    cs = (String)ec.nextElement();
                    informReqList.addElement(this.informSession.makeAsyncRequest(addr, cs, cb, fullVbl, this.getInformPort()));
                }
            }
        }
        return informReqList;
    }

    public SnmpInformRequest snmpInformRequest(InetAddress addr, String cs, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        return this.snmpInformRequest(addr, this.getInformPort(), cs, cb, trapOid, varBindList);
    }

    public SnmpInformRequest snmpInformRequest(SnmpPeer peer, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        SnmpParameters p = (SnmpParameters)peer.getParams();
        return this.snmpInformRequest(peer.getDestAddr(), peer.getDestPort(), p.getInformCommunity(), cb, trapOid, varBindList);
    }

    public static final int mapErrorStatus(int errorStatus, int protocolVersion, int reqPduType) {
        return SnmpSubRequestHandler.mapErrorStatus(errorStatus, protocolVersion, reqPduType);
    }

    private SnmpInformRequest snmpInformRequest(InetAddress addr, int port, String cs, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpInformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? (SnmpVarBindList)varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        return this.informSession.makeAsyncRequest(addr, cs, cb, fullVbl, port);
    }

    synchronized void openInformSocketIfNeeded() throws SocketException {
        if (this.informSession == null) {
            this.informSession = new SnmpSession(this);
            if (this.logger.finerOn()) {
                this.logger.finer("openInformSocketIfNeeded", "to send inform requests and receive inform responses");
            }
        }
    }

    synchronized void closeInformSocketIfNeeded() {
        if (this.informSession != null && this.state != 0) {
            this.informSession.destroySession();
            this.informSession = null;
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        InetAddress actual = this.socket != null ? this.socket.getLocalAddress() : (this.address != null ? this.address : null);
        if (actual == null) {
            return super.getHost();
        }
        if (actual.isAnyLocalAddress()) {
            try {
                return actual.getLocalHost().getHostName();
            }
            catch (UnknownHostException x) {
                this.logger.debug("getHost", "Can't determine local host name: " + x);
                return "localhost";
            }
        }
        return actual.getHostName();
    }

    public int getPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return super.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        finally {
            try {
                this.threadService.terminate();
            }
            catch (Exception exception) {}
        }
    }

    String makeDebugTag() {
        return "SnmpAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    ClassLogger makeLogger(String dbgTag) {
        return new ModifiableClassLogger("com.sun.jdmk.snmp.adaptor", dbgTag);
    }

    void updateRequestCounters(int pduType) {
        switch (pduType) {
            case 160: {
                ++this.snmpInGetRequests;
                break;
            }
            case 161: {
                ++this.snmpInGetNexts;
                break;
            }
            case 163: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    void updateErrorCounters(int errorStatus) {
        switch (errorStatus) {
            case 0: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 5: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 3: {
                ++this.snmpOutBadValues;
                break;
            }
            case 2: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 1: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    void updateVarCounters(int pduType, int n) {
        switch (pduType) {
            case 160: 
            case 161: 
            case 165: {
                this.snmpInTotalReqVars += n;
                break;
            }
            case 163: {
                this.snmpInTotalSetVars += n;
            }
        }
    }

    void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    void incSnmpSilentDrops(int n) {
        this.snmpSilentDrops += n;
    }

    public long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.mibs = new Vector();
    }

    private void updateLogger() {
        ((ModifiableClassLogger)this.logger).setClassName(this.makeDebugTag());
    }

    private void init(Object acl, int p, InetAddress a) {
        this.root = new SnmpMibTree();
        this.defaultAgent = new SnmpErrorHandlerAgent();
        this.root.setDefaultAgent(this.defaultAgent);
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactoryBER();
        this.setPort(p);
        this.ipacl = acl;
        this.address = a;
        if (this.logger.finerOn()) {
            this.logger.finer("init", "SnmpAdaptorServer will bind to " + this.address);
        }
        if (this.ipacl == null && this.useAcl) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
        this.threadService = new ThreadService(threadNumber);
    }

    SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    static int getThreadNumber() {
        return threadNumber;
    }

    static {
        String s = System.getProperty(THREAD_NUMBER_PROPERTY);
        if (s != null) {
            try {
                threadNumber = Integer.parseInt(s);
            }
            catch (Exception e) {
                System.err.println("Got wrong value for com.sun.management.snmp.threadnumber: " + s);
                System.err.println("Using the default value: " + threadNumber);
            }
        }
    }
}

