/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.comm.SnmpV3ResponseHandler;
import com.sun.management.comm.SnmpV3Session;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpV3Message;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import java.io.IOException;
import java.net.InetAddress;

public class SnmpV3InformRequest
extends SnmpInformRequest {
    private SnmpV3ResponseHandler respHandler = null;
    private SnmpScopedPduRequest v3pdu = null;
    private SnmpV3AdaptorServer v3adaptor = null;
    private SnmpVarBindList reportVarBindList = null;
    private String dbgTag = "SnmpV3InformRequest";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpV3InformRequest");

    SnmpV3InformRequest(SnmpV3Session session, SnmpV3ResponseHandler respHandler, SnmpV3AdaptorServer adp, InetAddress addr, SnmpScopedPduRequest v3pdu, SnmpInformHandler requestCB) throws SnmpStatusException {
        super(session, adp, addr, null, v3pdu.port, requestCB);
        this.respHandler = respHandler;
        this.v3adaptor = adp;
        this.v3pdu = v3pdu;
        v3pdu.type = 166;
        v3pdu.version = 3;
        v3pdu.address = addr;
    }

    public SnmpVarBindList getReportVarBindList() {
        return this.reportVarBindList;
    }

    synchronized void parsePduPacket(SnmpPduRequestType rpdu) {
        if (rpdu == null) {
            return;
        }
        if (logger.finerOn()) {
            logger.finer("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
        this.errorStatus = rpdu.getErrorStatus();
        this.errorIndex = rpdu.getErrorIndex();
        if (this.errorStatus == 0) {
            if (((SnmpPdu)((Object)rpdu)).type == 168) {
                if (logger.finerOn()) {
                    logger.finer("parsePduPacket", "received inform report.");
                }
                this.updateReportVarBindList(((SnmpPdu)((Object)rpdu)).varBindList);
            } else {
                if (logger.finerOn()) {
                    logger.finer("parsePduPacket", "received inform reponse.");
                }
                this.updateInternalVarBindWithResult(((SnmpPdu)((Object)rpdu)).varBindList);
            }
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        if (logger.finerOn()) {
            logger.finer("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private void updateReportVarBindList(SnmpVarBind[] list) {
        this.reportVarBindList = new SnmpVarBindList();
        for (int i = 0; i < list.length; ++i) {
            SnmpVarBind bind = list[i];
            SnmpVarBind var = new SnmpVarBind(bind.getOid(), bind.getSnmpValue());
            this.reportVarBindList.addVarBind(var);
        }
    }

    synchronized SnmpPdu constructPduPacket() {
        this.v3pdu.varBindList = this.internalVarBind;
        this.v3pdu.requestId = this.getRequestId();
        this.v3pdu.msgFlags = (byte)(this.v3pdu.msgFlags | 4);
        return this.v3pdu;
    }

    public boolean isReport() {
        if (this.responsePdu == null) {
            if (logger.finestOn()) {
                logger.finest("isReport", "responsePdu is null");
            }
            return false;
        }
        if (logger.finestOn()) {
            logger.finest("isReport", "responsePdu not null");
        }
        return ((SnmpPdu)((Object)this.responsePdu)).type == 168;
    }

    public boolean isResponse() {
        if (this.responsePdu == null) {
            if (logger.finestOn()) {
                logger.finest("isResponse", "responsePdu is null");
            }
            return false;
        }
        if (logger.finestOn()) {
            logger.finest("isResponse", "responsePdu not null");
        }
        return ((SnmpPdu)((Object)this.responsePdu)).type == 162;
    }

    boolean sendPdu() {
        try {
            this.responsePdu = null;
            this.reportVarBindList = null;
            SnmpPduFactory pduFactory = this.v3adaptor.getPduFactory();
            SnmpEngineImpl eng = (SnmpEngineImpl)this.v3adaptor.getEngine();
            SnmpMsgProcessingSubSystem msgsys = eng.getMsgProcessingSubSystem();
            SnmpOutgoingRequest req = msgsys.getOutgoingRequest(3, pduFactory);
            SnmpMsg msg = req.encodeSnmpPdu(this.requestPdu, this.v3adaptor.getBufferSize());
            if (msg == null) {
                if (logger.finestOn()) {
                    logger.finest("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            ((SnmpV3Message)msg).msgId = this.getRequestId();
            int maxPktSize = this.v3adaptor.getBufferSize();
            byte[] encoding = new byte[maxPktSize];
            int encodingLength = req.encodeMessage(encoding);
            if (logger.finerOn()) {
                logger.finer("sendPdu", "Dump : \n" + msg.printMessage());
            }
            this.respHandler.setSecurityCache(req.getSecurityCache());
            this.sendPduPacket(encoding, encodingLength);
            return true;
        }
        catch (SnmpTooBigException ar) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", ar);
            }
            this.setErrorStatusAndIndex(228, ar.getVarBindCount());
            this.requestPdu = null;
            this.reason = ar.getMessage();
            if (logger.finestOn()) {
                logger.finest("sendPdu", "Packet Overflow while building inform request");
            }
        }
        catch (IOException e) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(241, 0);
            this.reason = e.getMessage();
        }
        catch (SnmpSecurityException e) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(e.status, 0);
            this.reason = e.getMessage();
        }
        catch (SnmpUnknownMsgProcModelException e) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = e.getMessage();
        }
        catch (SnmpUnknownSecModelException e) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = e.getMessage();
        }
        catch (SnmpBadSecurityLevelException e) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(249, 0);
            this.reason = e.getMessage();
        }
        catch (SnmpStatusException e) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", e.toString());
            }
            this.setErrorStatusAndIndex(e.getStatus(), 0);
            this.reason = e.getMessage();
        }
        return false;
    }
}

