/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.UnsignedLong;
import com.sun.jdmk.defaults.Utils;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SnmpOid
extends SnmpValue {
    protected long[] components = null;
    protected int componentCount = 0;
    static final String name = "Object Identifier";
    private static SnmpOidTable meta = null;
    static final long serialVersionUID = 8956237235607885096L;

    public SnmpOid() {
        this.components = new long[15];
        this.componentCount = 0;
    }

    public SnmpOid(long[] oidComponents) {
        this.components = (long[])oidComponents.clone();
        this.componentCount = this.components.length;
    }

    public SnmpOid(long id) {
        this.components = new long[1];
        this.components[0] = id;
        this.componentCount = this.components.length;
    }

    public SnmpOid(long id1, long id2, long id3, long id4) {
        this.components = new long[4];
        this.components[0] = id1;
        this.components[1] = id2;
        this.components[2] = id3;
        this.components[3] = id4;
        this.componentCount = this.components.length;
    }

    public SnmpOid(String s) throws IllegalArgumentException {
        String dotString = s;
        if (!s.startsWith(".")) {
            try {
                dotString = this.resolveVarName(s);
            }
            catch (SnmpStatusException e) {
                IllegalArgumentException ie = new IllegalArgumentException(e.getMessage());
                Utils.initCause(ie, e);
                throw ie;
            }
        }
        StringTokenizer st = new StringTokenizer(dotString, ".", false);
        this.componentCount = st.countTokens();
        if (this.componentCount == 0) {
            this.components = new long[15];
        } else {
            this.components = new long[this.componentCount];
            try {
                for (int i = 0; i < this.componentCount; ++i) {
                    try {
                        this.components[i] = Long.parseLong(st.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(s);
            }
        }
    }

    public int getLength() {
        return this.componentCount;
    }

    public long[] longValue() {
        long[] result = new long[this.componentCount];
        System.arraycopy(this.components, 0, result, 0, this.componentCount);
        return result;
    }

    public final long[] longValue(boolean duplicate) {
        if (duplicate) {
            return this.longValue();
        }
        if (this.componentCount == this.components.length) {
            return this.components;
        }
        this.components = this.longValue();
        this.componentCount = this.components.length;
        return this.components;
    }

    public final long getOidArc(int pos) throws SnmpStatusException {
        try {
            return this.components[pos];
        }
        catch (Exception e) {
            throw new SnmpStatusException(6);
        }
    }

    public UnsignedLong toUnsignedLong() {
        if (this.componentCount != 1) {
            throw new IllegalArgumentException();
        }
        return UnsignedLong.make(this.components[0]);
    }

    public Long toLong() {
        if (this.componentCount != 1) {
            throw new IllegalArgumentException();
        }
        return new Long(this.components[0]);
    }

    public Integer toInteger() {
        if (this.componentCount != 1 || this.components[0] > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)this.components[0]);
    }

    public String toString() {
        String result = "";
        if (this.componentCount >= 1) {
            for (int i = 0; i < this.componentCount - 1; ++i) {
                result = result + this.components[i] + ".";
            }
            result = result + this.components[this.componentCount - 1];
        }
        return result;
    }

    public Boolean toBoolean() {
        if (this.componentCount != 1 && this.components[0] != 1L && this.components[0] != 2L) {
            throw new IllegalArgumentException();
        }
        return new Boolean(this.components[0] == 1L);
    }

    public Byte[] toByte() {
        Byte[] result = new Byte[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            result[i] = new Byte((byte)this.components[i]);
        }
        return result;
    }

    public SnmpOid toOid() {
        long[] ids = new long[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            ids[i] = this.components[i];
        }
        return new SnmpOid(ids);
    }

    public static SnmpOid toOid(long[] index, int start) throws SnmpStatusException {
        try {
            if (index[start] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int idCount = (int)index[start++];
            long[] ids = new long[idCount];
            for (int i = 0; i < idCount; ++i) {
                ids[i] = index[start + i];
            }
            return new SnmpOid(ids);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] index, int start) throws SnmpStatusException {
        try {
            int idCount;
            if (index[start] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((start += (idCount = (int)index[start++])) <= index.length) {
                return start;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid source, SnmpOid dest) {
        dest.append(source.getLength());
        dest.append(source);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public Object clone() {
        try {
            SnmpOid obj = (SnmpOid)super.clone();
            obj.components = new long[this.componentCount];
            System.arraycopy(this.components, 0, obj.components, 0, this.componentCount);
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void insert(long id) {
        this.enlargeIfNeeded(1);
        for (int i = this.componentCount - 1; i >= 0; --i) {
            this.components[i + 1] = this.components[i];
        }
        this.components[0] = id;
        ++this.componentCount;
    }

    public void insert(int id) {
        this.insert((long)id);
    }

    public void append(SnmpOid oid) {
        this.enlargeIfNeeded(oid.componentCount);
        for (int i = 0; i < oid.componentCount; ++i) {
            this.components[this.componentCount + i] = oid.components[i];
        }
        this.componentCount += oid.componentCount;
    }

    public void append(long id) {
        this.enlargeIfNeeded(1);
        this.components[this.componentCount] = id;
        ++this.componentCount;
    }

    public void addToOid(String s) throws SnmpStatusException {
        SnmpOid suffix = new SnmpOid(s);
        this.append(suffix);
    }

    public void addToOid(long[] oid) throws SnmpStatusException {
        SnmpOid suffix = new SnmpOid(oid);
        this.append(suffix);
    }

    public boolean isValid() {
        return this.componentCount >= 2 && 0L <= this.components[0] && this.components[0] < 3L && 0L <= this.components[1] && this.components[1] < 40L;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof SnmpOid) {
            SnmpOid oid = (SnmpOid)o;
            if (oid.componentCount == this.componentCount) {
                int i;
                long[] objoid = oid.components;
                for (i = 0; i < this.componentCount && this.components[i] == objoid[i]; ++i) {
                }
                result = i == this.componentCount;
            }
        }
        return result;
    }

    public int hashCode() {
        long acc = 0L;
        for (int i = 0; i < this.componentCount; ++i) {
            acc = acc * 31L + this.components[i];
        }
        return (int)acc;
    }

    public int compareTo(SnmpOid other) {
        int result = 0;
        int i = 0;
        int cmplen = Math.min(this.componentCount, other.componentCount);
        long[] otheroid = other.components;
        for (i = 0; i < cmplen && this.components[i] == otheroid[i]; ++i) {
        }
        result = i == this.componentCount && i == other.componentCount ? 0 : (i == this.componentCount ? -1 : (i == other.componentCount ? 1 : (this.components[i] < otheroid[i] ? -1 : 1)));
        return result;
    }

    public String resolveVarName(String s) throws SnmpStatusException {
        int index = s.indexOf(46);
        SnmpOidTable symbols = SnmpOid.getSnmpOidTable();
        try {
            return this.handleLong(s, index);
        }
        catch (NumberFormatException e) {
            if (symbols == null) {
                throw new SnmpStatusException(2);
            }
            if (index <= 0) {
                SnmpOidRecord rec = symbols.resolveVarName(s);
                return rec.getOid();
            }
            SnmpOidRecord rec = symbols.resolveVarName(s.substring(0, index));
            return rec.getOid() + s.substring(index);
        }
    }

    public String getTypeName() {
        return name;
    }

    public static synchronized SnmpOidTable getSnmpOidTable() {
        return meta;
    }

    public static synchronized void setSnmpOidTable(SnmpOidTable db) {
        meta = db;
    }

    public String toOctetString() {
        return new String(this.tobyte());
    }

    private byte[] tobyte() {
        byte[] result = new byte[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            result[i] = (byte)this.components[i];
        }
        return result;
    }

    private void enlargeIfNeeded(int n) {
        int neededSize;
        for (neededSize = this.components.length; this.componentCount + n > neededSize; neededSize *= 2) {
        }
        if (neededSize > this.components.length) {
            long[] newComponents = new long[neededSize];
            for (int i = 0; i < this.components.length; ++i) {
                newComponents[i] = this.components[i];
            }
            this.components = newComponents;
        }
    }

    private String handleLong(String oid, int index) throws NumberFormatException, SnmpStatusException {
        String str = index > 0 ? oid.substring(0, index) : oid;
        Long.parseLong(str);
        return oid;
    }
}

