/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpStatusException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpOidTableSupport
implements SnmpOidTable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpOidTableSupport");
    String dbgTag = "SnmpOidTableSupport";
    private Hashtable oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String name) {
        this.myName = name;
    }

    public SnmpOidRecord resolveVarName(String name) throws SnmpStatusException {
        SnmpOidRecord var = (SnmpOidRecord)this.oidStore.get(name);
        if (var != null) {
            return var;
        }
        throw new SnmpStatusException("Variable name <" + name + "> not found in Oid repository");
    }

    public SnmpOidRecord resolveVarOid(String oid) throws SnmpStatusException {
        int index = oid.indexOf(46);
        if (index < 0) {
            throw new SnmpStatusException("Variable oid <" + oid + "> not found in Oid repository");
        }
        if (index == 0) {
            oid = oid.substring(1, oid.length());
        }
        Enumeration list = this.oidStore.elements();
        while (list.hasMoreElements()) {
            SnmpOidRecord element = (SnmpOidRecord)list.nextElement();
            if (!element.getOid().equals(oid)) continue;
            return element;
        }
        throw new SnmpStatusException("Variable oid <" + oid + "> not found in Oid repository");
    }

    public Vector getAllEntries() {
        Vector elementsVector = new Vector();
        Enumeration e = this.oidStore.elements();
        while (e.hasMoreElements()) {
            elementsVector.addElement(e.nextElement());
        }
        return elementsVector;
    }

    public synchronized void loadMib(SnmpOidRecord[] mibs) {
        try {
            int i = 0;
            while (true) {
                SnmpOidRecord s = mibs[i];
                if (logger.finerOn()) {
                    logger.finer("loadMib", "load " + s.getName());
                }
                this.oidStore.put(s.getName(), s);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport val = (SnmpOidTableSupport)object;
        return this.myName.equals(val.getName());
    }

    public String getName() {
        return this.myName;
    }
}

