/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.Timestamp;
import com.sun.management.snmp.manager.ReqRedirectSrv;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

final class MultiplexRequest
implements Serializable,
SnmpRequestHandler,
SnmpDefinitions,
ReqRedirectSrv {
    private static final long serialVersionUID = 7456830883773007669L;
    private SnmpPeer thepeer;
    private SnmpSession asession;
    private int command;
    private SnmpRequest multiplexReq;
    private Vector vbmuxList = null;
    static final String nl = "\n";
    SnmpVarBindList multiplexVb;
    String dbgTag = "MultiplexRequest";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "MultiplexRequest");

    public MultiplexRequest(SnmpPeer peer, SnmpSession sess, int cmd) {
        this.thepeer = peer;
        this.asession = sess;
        this.command = cmd;
        this.multiplexVb = new SnmpVarBindList("Multiplexed varBind list");
        this.vbmuxList = new Vector();
    }

    public final SnmpPeer getPeer() {
        return this.thepeer;
    }

    public final SnmpSession getSnmpSession() {
        return this.asession;
    }

    public final int getCommand() {
        return this.command;
    }

    public Enumeration getElements() {
        return this.vbmuxList.elements();
    }

    public synchronized boolean addRequest(SnmpRequest snmpreq) {
        if (this.multiplexVb.size() + snmpreq.getVarBindList().size() > this.getPeer().getVarBindLimit()) {
            return false;
        }
        this.buildMultiplexVblist(snmpreq);
        return true;
    }

    public synchronized void action() {
        block6: {
            if (this.vbmuxList.isEmpty()) {
                return;
            }
            if (this.vbmuxList.size() == 1) {
                VbMultiplexMap vbmuxElem = (VbMultiplexMap)this.vbmuxList.firstElement();
                this.deleteFromMuxPool(vbmuxElem);
                SnmpRequest req = vbmuxElem.getRequest();
                req.action();
                return;
            }
            try {
                if (this.multiplexReq == null) {
                    this.multiplexReq = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
                    this.multiplexReq.setOptions(6);
                    this.multiplexReq.setInternalRequest();
                }
                if (logger.finerOn()) {
                    logger.finer("action", "Multiplex request just before firing\n" + this.debugMultiplexing());
                }
                this.multiplexReq.start(this.multiplexVb, false, 0L);
            }
            catch (Exception me) {
                if (!logger.finestOn()) break block6;
                logger.finest("action", me);
            }
        }
    }

    public final synchronized String toString() {
        StringBuffer sb = new StringBuffer(500);
        int vbcount = 0;
        Enumeration muxe = this.getElements();
        sb.append(this.getPeer().toString());
        sb.append(" -> Requests being Multiplexed = ");
        while (muxe.hasMoreElements()) {
            VbMultiplexMap vbmuxElem = (VbMultiplexMap)muxe.nextElement();
            SnmpRequest req = vbmuxElem.getRequest();
            sb.append(req.getRequestId() + ", ");
            vbcount += req.getVarBindList().size();
        }
        sb.append("\nTotal varBind count of all requests = " + vbcount);
        if (this.multiplexVb == null) {
            sb.append("   Multiplexed varBind not initialized.");
        } else {
            sb.append("    Multiplexed varBind count = " + this.multiplexVb.size());
        }
        sb.append("\nCorresponding Multiplex Request Status : \n");
        if (this.multiplexReq != null) {
            sb.append(this.multiplexReq.toString());
        } else {
            sb.append("Not created yet!! ");
        }
        return sb.toString();
    }

    public synchronized void cancel(SnmpRequest snmpreq) {
        this.deleteFromMuxPool(snmpreq);
        SnmpVarBindList newvb = snmpreq.getVarBindList().cloneWithoutValue();
        snmpreq.setVarBindList(newvb);
    }

    public synchronized void processSnmpPollData(SnmpRequest req, int errStatus, int errIndex, SnmpVarBindList vblst) {
        switch (errStatus) {
            case 0: {
                this.handleSuccess(vblst);
                break;
            }
            case 1: {
                if (logger.finestOn()) {
                    logger.finest("processSnmpPollData", "Too-big error while multiplexing");
                }
            }
            default: {
                this.handleError(vblst, errStatus, errIndex);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest mreq) {
        Enumeration muxe = this.getElements();
        while (muxe.hasMoreElements()) {
            VbMultiplexMap reqmap = (VbMultiplexMap)muxe.nextElement();
            SnmpRequest req = reqmap.getRequest();
            if (!req.inProgress()) continue;
            req.setErrorStatusAndIndex(224, 0);
            req.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (logger.finestOn()) {
                logger.finest("processSnmpPollTimeout", "Timeout occured while processing multiplexed request");
            }
            req.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public synchronized void processSnmpInternalError(SnmpRequest mreq, String msg) {
        Enumeration muxe = this.getElements();
        while (muxe.hasMoreElements()) {
            VbMultiplexMap reqmap = (VbMultiplexMap)muxe.nextElement();
            SnmpRequest req = reqmap.getRequest();
            if (!req.inProgress()) continue;
            req.setErrorStatusAndIndex(240, 0);
            req.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (logger.finestOn()) {
                logger.finest("processSnmpInternalError", "Internal error while processing multiplexed request");
            }
            req.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public synchronized String debugMultiplexing() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("\nMultiplex Object Description BEGIN=> \n");
        sb.append(this.toString() + nl);
        sb.append("\nMultiplex VarBindList-> \n");
        sb.append(this.multiplexVb.oidListToString());
        sb.append("\nIndividual Request Description .....\n");
        Enumeration mape = this.getElements();
        while (mape.hasMoreElements()) {
            VbMultiplexMap vbmuxElem = (VbMultiplexMap)mape.nextElement();
            SnmpRequest req = vbmuxElem.getRequest();
            sb.append("\nRequestId = " + req.getRequestId());
            sb.append(nl + req.getVarBindList().oidListToString());
        }
        sb.append("\nMultiplex Object Description ENDS=> \n");
        return sb.toString();
    }

    private synchronized void buildMultiplexVblist(SnmpRequest snmpreq) {
        VbMultiplexMap reqmap = new VbMultiplexMap(snmpreq);
        reqmap.compress(this.multiplexVb);
        snmpreq.setProxyObject(this);
        this.addToMuxPool(reqmap);
    }

    private void addToMuxPool(VbMultiplexMap elem) {
        this.vbmuxList.addElement(elem);
    }

    private void deleteFromMuxPool(VbMultiplexMap elem) {
        this.vbmuxList.removeElement(elem);
        elem.getRequest().setProxyObject(null);
    }

    private void deleteFromMuxPool(SnmpRequest req) {
        this.vbmuxList.removeElement(req);
        req.setProxyObject(null);
    }

    private void clearMuxPool() {
        this.vbmuxList.removeAllElements();
    }

    synchronized void handleError(SnmpVarBindList vblst, int errStatus, int errIndex) {
        SnmpRequest req;
        Enumeration muxe = this.getElements();
        Vector<SnmpRequest> retryList = new Vector<SnmpRequest>();
        while (muxe.hasMoreElements()) {
            VbMultiplexMap reqmap = (VbMultiplexMap)muxe.nextElement();
            req = reqmap.getRequest();
            if (!req.inProgress()) continue;
            int erridx = reqmap.findMatchIndex(errIndex);
            if (erridx < 0) {
                retryList.addElement(req);
                continue;
            }
            req.setErrorStatusAndIndex(errStatus, erridx);
            req.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            req.invokeOnResponse(null);
        }
        if (retryList.isEmpty()) {
            return;
        }
        this.clearMuxPool();
        Enumeration reqe = retryList.elements();
        while (reqe.hasMoreElements()) {
            req = (SnmpRequest)reqe.nextElement();
            this.buildMultiplexVblist(req);
        }
        this.action();
    }

    synchronized void handleSuccess(SnmpVarBindList vblst) {
        Enumeration muxe = this.getElements();
        Timestamp timestamp = vblst.getTimestamp();
        while (muxe.hasMoreElements()) {
            VbMultiplexMap reqmap = (VbMultiplexMap)muxe.nextElement();
            SnmpRequest req = reqmap.getRequest();
            if (!req.inProgress()) continue;
            req.setErrorStatusAndIndex(0, 0);
            if (this.command == 161) {
                reqmap.uncompressAndCopyVar(this.multiplexVb);
            } else {
                reqmap.uncompressAndCopyValue(this.multiplexVb);
            }
            req.getVarBindList().setTimestamp(timestamp);
            req.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
        }
        if (logger.finestOn()) {
            StringBuffer s = new StringBuffer(1024);
            s.append("Received successsful response to demultiplexed request...\n");
            s.append(vblst.varBindListToString());
            s.append("Individual requestBreakup follows :::\n");
            Enumeration dbgmuxe = this.getElements();
            while (dbgmuxe.hasMoreElements()) {
                VbMultiplexMap reqmap = (VbMultiplexMap)dbgmuxe.nextElement();
                SnmpRequest req = reqmap.getRequest();
                if (!req.inProgress()) continue;
                s.append("\nDemultiplexed Request = " + req.getRequestId());
                s.append(nl + req.getVarBindList().varBindListToString() + nl);
            }
            logger.finest("handleSuccess", "Demultiplexing Request as follows:\n" + s.toString());
        }
        Enumeration muxreqe = this.getElements();
        while (muxreqe.hasMoreElements()) {
            VbMultiplexMap reqmap = (VbMultiplexMap)muxreqe.nextElement();
            SnmpRequest req = reqmap.getRequest();
            req.invokeOnResponse(null);
        }
    }

    final class VbMultiplexMap {
        SnmpRequest thereq;
        SnmpVarBindList vblst;
        int[] mapidx;
        int size = 0;

        public VbMultiplexMap(SnmpRequest req) {
            this.thereq = req;
            this.vblst = this.thereq.getVarBindList();
            this.size = this.vblst.size();
            this.mapidx = new int[this.size];
        }

        synchronized SnmpRequest getRequest() {
            return this.thereq;
        }

        public final synchronized boolean equals(Object obj) {
            if (obj instanceof SnmpRequest) {
                return this.thereq == obj;
            }
            return super.equals(obj);
        }

        synchronized void compress(SnmpVarBindList multiplexVb) {
            int endidx = multiplexVb.size();
            if (endidx == 0) {
                multiplexVb.concat(this.vblst);
                this.mapidx = null;
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                SnmpVarBind svar = this.vblst.getVarBindAt(i);
                int findidx = multiplexVb.indexOfOid(svar, 0, endidx);
                if (findidx < 0) {
                    multiplexVb.addVarBind(svar);
                    this.mapidx[i] = multiplexVb.size() * -1;
                    continue;
                }
                this.mapidx[i] = findidx;
            }
        }

        synchronized void uncompressAndCopyValue(SnmpVarBindList multiplexVb) {
            if (this.mapidx == null) {
                return;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int j = this.mapidx[i];
                if (j < 0) continue;
                SnmpVarBind avar = multiplexVb.getVarBindAt(j);
                this.vblst.getVarBindAt(i).copyValue(avar);
            }
        }

        synchronized void uncompressAndCopyVar(SnmpVarBindList multiplexVb) {
            if (this.mapidx == null) {
                return;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int j = this.mapidx[i];
                if (j < 0) continue;
                SnmpVarBind avar = multiplexVb.getVarBindAt(j);
                this.vblst.getVarBindAt(i).copyValueAndOid(avar);
            }
        }

        synchronized int findMatchIndex(int errid) {
            if (this.mapidx == null) {
                if (errid < this.size) {
                    return errid;
                }
                return -1;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int j = this.mapidx[i];
                if (j != errid && -j != errid) continue;
                return i;
            }
            return -1;
        }
    }
}

