/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.uacl;

import com.sun.management.snmp.uacl.AclEntryImpl;
import com.sun.management.snmp.uacl.OwnerImpl;
import com.sun.management.snmp.uacl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = -3477478331948334755L;
    private Vector entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl owner, String name) {
        super(owner);
        this.aclName = name;
    }

    public void setName(Principal caller, String name) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.aclName = name;
    }

    public String getName() {
        return this.aclName;
    }

    public boolean addEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(entry)) {
            return false;
        }
        this.entryList.addElement(entry);
        return true;
    }

    public boolean removeEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(entry);
    }

    public void removeAll(Principal caller) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    public Enumeration getPermissions(Principal user) {
        Vector empty = new Vector();
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = (AclEntry)e.nextElement();
            if (!((Object)ent.getPrincipal()).equals(user)) continue;
            return ent.permissions();
        }
        return empty.elements();
    }

    public Enumeration entries() {
        return this.entryList.elements();
    }

    public boolean checkPermission(Principal user, Permission perm) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = (AclEntry)e.nextElement();
            if (!((Object)ent.getPrincipal()).equals(user) || !ent.checkPermission(perm)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal user, String community, int securityLevel, Permission perm) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            int sec = ent.getSecurityLevel();
            if (!((Object)ent.getPrincipal()).equals(user) || !ent.checkPermission(perm) || !ent.checkContextName(community) || !ent.checkSecurityLevel(securityLevel)) continue;
            return true;
        }
        return false;
    }

    public boolean checkContextName(String community) {
        Enumeration e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            if (!ent.checkContextName(community)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

