/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.uacl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.UserAcl;
import com.sun.management.snmp.uacl.AclEntryImpl;
import com.sun.management.snmp.uacl.AclImpl;
import com.sun.management.snmp.uacl.JDMSecurityDefs;
import com.sun.management.snmp.uacl.ParseException;
import com.sun.management.snmp.uacl.Parser;
import com.sun.management.snmp.uacl.PermissionImpl;
import com.sun.management.snmp.uacl.PrincipalImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;

public class JdmkUserAcl
implements UserAcl,
Serializable {
    private static final long serialVersionUID = 792943185727781789L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "JdmkUserAcl");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkUserAcl(String name, String fileName) throws IllegalArgumentException {
        block4: {
            this.dbgTag = "JdmkUserAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, name);
                AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
                ownEntry.addPermission(READ);
                ownEntry.addPermission(WRITE);
                this.acl.addEntry(this.owner, ownEntry);
            }
            catch (NotOwnerException ex) {
                if (!logger.finestOn()) break block4;
                logger.finest("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (fileName == null) {
            this.setDefautFileName();
        } else {
            this.authorizedListFile = fileName;
        }
        this.readAuthorisedListFile();
    }

    public JdmkUserAcl(String name) throws IllegalArgumentException {
        this(name, null);
    }

    public synchronized Enumeration entries() {
        return this.acl.entries();
    }

    public synchronized String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public synchronized void setAuthorizedListFile(String filename) throws IllegalArgumentException, NotOwnerException {
        if (filename == null) {
            throw new IllegalArgumentException("The specified file is null");
        }
        File file = new File(filename);
        if (!file.isFile()) {
            if (logger.finestOn()) {
                logger.finest("setAuthorizedListFile", "User ACL file not found. Wrong passed file : " + filename);
            }
            throw new IllegalArgumentException("The specified file [" + filename + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (logger.finerOn()) {
            logger.finer("setAuthorizedListFile", "Default file set to " + filename);
        }
        this.authorizedListFile = filename;
        this.rereadTheFile();
    }

    public synchronized void rereadTheFile() throws NotOwnerException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
        ownEntry.addPermission(READ);
        ownEntry.addPermission(WRITE);
        this.acl.addEntry(this.owner, ownEntry);
        this.readAuthorisedListFile();
    }

    public synchronized String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public synchronized boolean checkReadPermission(String user) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(user);
        return this.acl.checkPermission(p, READ);
    }

    public synchronized boolean checkReadPermission(String user, String context, int securityLevel) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(user);
        return this.acl.checkPermission(p, context, securityLevel, READ);
    }

    public synchronized boolean checkContextName(String context) {
        return this.acl.checkContextName(context);
    }

    public synchronized boolean checkWritePermission(String user) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(user);
        return this.acl.checkPermission(p, WRITE);
    }

    public synchronized boolean checkWritePermission(String user, String context, int securityLevel) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(user);
        return this.acl.checkPermission(p, context, securityLevel, WRITE);
    }

    private static void checkCanRead(String f) throws IllegalArgumentException {
        File file = new File(f);
        if (file.isFile() && !file.canRead()) {
            throw new IllegalArgumentException("User ACL file is not readable.");
        }
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (logger.finerOn()) {
                logger.finer("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Parser parser = null;
            try {
                JdmkUserAcl.checkCanRead(this.getAuthorizedListFile());
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException e) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                JDMSecurityDefs n = parser.SecurityDefs();
                n.buildAclEntries(this.owner, this.acl);
                n.buildTrapEntries(this.trapDestList);
                n.buildInformEntries(this.informDestList);
            }
            catch (ParseException e) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Parsing exception " + e);
                }
                IllegalArgumentException ie = new IllegalArgumentException("Syntax error: " + e);
                Utils.initCause(ie, e);
                throw ie;
            }
            catch (Error err) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Error exception " + err);
                }
                IllegalArgumentException ie = new IllegalArgumentException("Error: " + err);
                Utils.initCause(ie, err);
                throw ie;
            }
            Enumeration e = this.acl.entries();
            while (e.hasMoreElements()) {
                AclEntryImpl aa = (AclEntryImpl)e.nextElement();
                if (logger.finerOn()) {
                    logger.finer("readAuthorisedListFile", "===> " + ((Object)aa.getPrincipal()).toString());
                }
                Enumeration eee = aa.permissions();
                while (eee.hasMoreElements()) {
                    Permission perm = (Permission)eee.nextElement();
                    if (!logger.finerOn()) continue;
                    logger.finer("readAuthorisedListFile", "perm = " + perm);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String aclFile = null;
        File file = null;
        aclFile = System.getProperty("jdmk.uacl.file");
        if (aclFile == null) {
            aclFile = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.uacl");
            if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default File name is : " + aclFile);
            }
            if ((file = new File(aclFile)).isFile()) {
                if (logger.finerOn()) {
                    logger.finer("setDefautFileName", "Default User ACL file found : " + aclFile);
                }
            } else if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default User ACL file not found.");
            }
        } else {
            file = new File(aclFile);
            if (!file.isFile()) {
                if (logger.finestOn()) {
                    logger.finest("setDefautFileName", "User ACL file not found. Wrong java property : jdmk.uacl.file=" + aclFile);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (logger.finerOn()) {
                logger.finer("setDefautFileName", "User ACL file found : " + aclFile);
            }
        }
        this.authorizedListFile = aclFile;
    }
}

