/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.End;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.buf.Base64Utils;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class BayeuxParser {
    private static Level level = Level.FINE;
    private static boolean enforceSubscriptionUnderPush = true;
    public static final String DEFAULT_CONTENT_TYPE = "application/json-comment-filtered";
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentHashMap<String, AbstractQueue<String>> inactiveChannels = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap<String, Boolean> authenticatedUsers = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap<String, CometContext> activeCometContexts = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap<String, DataHandler> activeCometHandlers = new ConcurrentHashMap(16, 0.75f, 64);
    private final ThreadLocal<Set<String>> deliverInChannels = new ThreadLocal<Set<String>>(){

        @Override
        protected Set initialValue() {
            return new HashSet();
        }
    };

    public void parse(CometdContext cometdContext) throws IOException {
        this.log(cometdContext.getVerb().toString());
        switch (cometdContext.getVerb().getType()) {
            case HANDSHAKE: {
                this.onHandshake(cometdContext);
                break;
            }
            case CONNECT: {
                this.onConnect(cometdContext);
                break;
            }
            case DISCONNECT: {
                this.onDisconnect(cometdContext);
                break;
            }
            case RECONNECT: {
                this.onReconnect(cometdContext);
                break;
            }
            case SUBSCRIBE: {
                this.onSubscribe(cometdContext);
                break;
            }
            case UNSUBSCRIBE: {
                this.onUnsubscribe(cometdContext);
                break;
            }
            case PUBLISH: {
                this.onPublish(cometdContext);
                break;
            }
            case PING: {
                this.onPing(cometdContext);
                break;
            }
            case STATUS: {
                this.onStatus(cometdContext);
                break;
            }
        }
    }

    public void onHandshake(CometdContext cometdContext) throws IOException {
        CometdResponse res = cometdContext.getResponse();
        HandshakeRequest handshakeReq = (HandshakeRequest)cometdContext.getVerb();
        HandshakeResponse handshakeRes = new HandshakeResponse(handshakeReq);
        handshakeRes.setAdvice(new Advice());
        if (handshakeReq.isValid()) {
            byte[] ba;
            String clientId = null;
            do {
                ba = new byte[16];
                this.random.nextBytes(ba);
            } while (this.authenticatedUsers.putIfAbsent(clientId = Base64Utils.encodeToString((byte[])ba, (boolean)false), Boolean.TRUE) != null);
            handshakeRes.setClientId(clientId);
        } else {
            handshakeRes.setSuccessful(false);
            handshakeRes.setError("501::invalid handshake");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshakeRes.toJSON());
        res.flush();
    }

    public void onConnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ConnectRequest connectReq = (ConnectRequest)cometdContext.getVerb();
        ConnectResponse connectRes = new ConnectResponse(connectReq);
        connectRes.setAdvice(new Advice());
        String errorMessage = this.isAuthenticatedAndValid(connectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            String clientId = connectReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && dataHandler.getChannels().size() > 0) {
                res.write(connectRes.toLongPolledJSON());
                for (String channel : dataHandler.getChannels()) {
                    CometContext cc = this.getCometContext(channel);
                    if (cc.getCometHandler(dataHandler.hashCode()) != null) continue;
                    this.log("Suspending client: " + clientId + " channel: " + channel);
                    dataHandler.attach(new Object[]{req, res});
                    cc.addCometHandler((CometHandler)dataHandler);
                    dataHandler.setSuspended(true);
                }
                connectRes.setAdvice(null);
            } else {
                res.write(connectRes.toJSON());
            }
            res.flush();
        } else {
            res.write(errorMessage);
        }
    }

    public void onDisconnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        DisconnectRequest disconnectReq = (DisconnectRequest)cometdContext.getVerb();
        DisconnectResponse disconnectRes = new DisconnectResponse(disconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(disconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            this.activeCometHandlers.remove(disconnectReq.getClientId());
            this.authenticatedUsers.remove(disconnectReq.getClientId());
            res.write(disconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(disconnectRes, req.getRemotePort());
    }

    public void onReconnect(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ReconnectRequest reconnectReq = (ReconnectRequest)cometdContext.getVerb();
        ReconnectResponse reconnectRes = new ReconnectResponse(reconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(reconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            res.write(reconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(reconnectRes, req.getRemotePort());
    }

    public void onSubscribe(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        SubscribeRequest subscribeReq = (SubscribeRequest)cometdContext.getVerb();
        SubscribeResponse subscribeRes = new SubscribeResponse(subscribeReq);
        String errorMessage = this.isAuthenticatedAndValid(subscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            String clientId = subscribeReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler == null) {
                dataHandler = new DataHandler(this);
                dataHandler.setClientId(clientId);
                this.activeCometHandlers.put(clientId, dataHandler);
            }
            dataHandler.addChannel(subscribeReq.getSubscription());
            if (dataHandler.isSuspended()) {
                subscribeRes.setLast(true);
            }
            res.write(subscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        this.notifyEnd(subscribeRes, req.getRemotePort());
    }

    public void onUnsubscribe(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        UnsubscribeRequest unsubscribeReq = (UnsubscribeRequest)cometdContext.getVerb();
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse(unsubscribeReq);
        boolean hasSubscription = false;
        DataHandler dataHandler = null;
        String clientId = unsubscribeReq.getClientId();
        String subscription = unsubscribeReq.getSubscription();
        String errorMessage = this.isAuthenticatedAndValid(unsubscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && (hasSubscription = dataHandler.containsChannel(subscription))) {
                AbstractQueue<String> uscs;
                Object unsubscribedChannels = this.inactiveChannels.get(clientId);
                if (unsubscribedChannels == null && (uscs = this.inactiveChannels.putIfAbsent(clientId, (AbstractQueue<String>)(unsubscribedChannels = new LinkedTransferQueue()))) != null) {
                    unsubscribedChannels = uscs;
                }
                unsubscribedChannels.add((String)subscription);
            }
            unsubscribeRes.setSuccessful(hasSubscription);
            res.write(unsubscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(unsubscribeRes, req.getRemotePort());
        if (hasSubscription) {
            dataHandler.removeChannel(subscription);
        }
    }

    public void onPublish(CometdContext cometdContext) throws IOException {
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        PublishRequest publishReq = (PublishRequest)cometdContext.getVerb();
        PublishResponse publishRes = new PublishResponse(publishReq);
        DeliverResponse deliverRes = null;
        String errorMessage = this.isAuthenticatedAndValid(publishReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        DataHandler dataHandler = null;
        if (errorMessage != null) {
            res.write(errorMessage);
            return;
        }
        publishRes.setSuccessful(true);
        String clientId = publishReq.getClientId();
        if (clientId != null) {
            dataHandler = this.activeCometHandlers.get(clientId);
        }
        boolean justSubscribedInTheSameRequest = dataHandler != null && dataHandler.getRemotePort() == -1;
        boolean deliverToSamePort = justSubscribedInTheSameRequest || dataHandler != null && dataHandler.getRemotePort() == req.getRemotePort();
        Data data = publishReq.getData();
        if (data != null) {
            deliverRes = new DeliverResponse(publishReq);
            deliverRes.setFollow(true);
            if (publishReq.isFirst()) {
                deliverRes.setFirst(false);
            }
        }
        if (publishReq.isLast() && deliverRes != null && deliverToSamePort) {
            publishRes.setLast(false);
        }
        res.write(publishRes.toJSON());
        if (deliverRes != null) {
            this.deliverInChannels.get().add(publishReq.getChannel());
            if (justSubscribedInTheSameRequest) {
                res.write(deliverRes.toJSON());
            }
            this.notifyAll(deliverRes, publishRes.getChannel());
        }
        this.notifyEnd(deliverRes, req.getRemotePort());
    }

    private void notifyAll(Object obj, String channel) throws IOException {
        if (enforceSubscriptionUnderPush) {
            for (Map.Entry<String, CometContext> entry : this.activeCometContexts.entrySet()) {
                entry.getValue().notify(obj);
            }
        } else {
            CometContext cc = this.getCometContext(channel);
            this.log("Notifying " + channel + " to " + cc.getCometHandlers().size() + " CometHandler with message\n" + obj);
            cc.notify(obj);
        }
    }

    private void notifyEnd(VerbBase verb, int requestPort) throws IOException {
        if (verb.isLast()) {
            AbstractQueue<String> unsubscribedChannels;
            Set<String> dic = this.deliverInChannels.get();
            if (dic.size() > 0) {
                End end = new End(requestPort, dic);
                this.notifyAll(end, dic.iterator().next());
                dic.clear();
            }
            String clientId = verb.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            Collection<String> subscribedChannels = null;
            if (dataHandler != null) {
                subscribedChannels = dataHandler.getChannels();
            }
            if (subscribedChannels != null && subscribedChannels.size() > 0) {
                int i = 0;
                for (String channel : subscribedChannels) {
                    this.log("Removing subscribed " + channel);
                    if (i++ == 0) continue;
                    this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                }
            }
            if ((unsubscribedChannels = this.inactiveChannels.get(clientId)) != null && !unsubscribedChannels.isEmpty()) {
                int i = 0;
                for (String channel : unsubscribedChannels) {
                    this.log("Removing unsubscribed " + channel);
                    if (i++ == 0) continue;
                    this.getCometContext(channel).getCometHandlers().remove(dataHandler);
                }
            }
            if (unsubscribedChannels != null) {
                unsubscribedChannels.clear();
                this.inactiveChannels.remove(clientId);
            }
        }
    }

    private String isAuthenticatedAndValid(VerbBase verb) {
        String clientId = verb.getClientId();
        if (clientId == null) {
            return null;
        }
        if (clientId != null && !this.authenticatedUsers.containsKey(clientId)) {
            return BayeuxParser.constructError("402", "Unknown Client", verb.getMetaChannel());
        }
        if (!verb.isValid()) {
            return BayeuxParser.constructError("501", "Invalid Operation", verb.getMetaChannel());
        }
        return null;
    }

    private static final String constructError(String errorMessage, String errorMsg, String meta) {
        StringBuilder sb = new StringBuilder();
        sb.append("[{\"successful\":false,\"error\":\"");
        sb.append(errorMessage);
        sb.append("::");
        sb.append(errorMsg);
        sb.append("\",\"advice\":{\"reconnect\":\"handshake\"},\"channel\":\"");
        sb.append(meta);
        sb.append("\"}]");
        return sb.toString();
    }

    private CometContext getCometContext(String channel) {
        CometContext cc = this.activeCometContexts.get(channel);
        if (cc == null) {
            cc = this.createCometContext(channel);
            this.activeCometContexts.put(channel, cc);
        }
        return cc;
    }

    private CometContext createCometContext(String channel) {
        CometContext cc = CometEngine.getEngine().register(channel);
        cc.setExpirationDelay(-1L);
        cc.setBlockingNotification(true);
        return cc;
    }

    protected void log(String log) {
        if (SelectorThread.logger().isLoggable(level)) {
            SelectorThread.logger().log(level, log);
        }
    }

    public void onPing(CometdContext cometdContext) throws IOException {
    }

    public void onStatus(CometdContext cometdContext) throws IOException {
    }

    static {
        if (System.getProperty("com.sun.grizzly.cometd.logAll") != null) {
            level = Level.INFO;
        }
        if (System.getProperty("com.sun.grizzly.cometd.enforceSubscription") != null) {
            enforceSubscriptionUnderPush = false;
        }
    }
}

