/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.DefaultRackApplication;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackApplicationFactory;
import com.sun.grizzly.jruby.rack.RackInitializationException;
import com.sun.grizzly.jruby.rack.RackResponse;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DefaultRackApplicationFactory
implements RackApplicationFactory {
    private RackApplication errorApplication;
    protected final Logger logger;
    final String appRoot;
    protected final RackGrizzlyAdapter adapter;

    public DefaultRackApplicationFactory(RackGrizzlyAdapter adapter) {
        this.logger = adapter.getLogger();
        this.appRoot = adapter.config.appRoot();
        this.adapter = adapter;
    }

    public RackApplication newApplication(final Ruby runtime) throws RackInitializationException {
        return this.createApplication(new ApplicationObjectFactory(){

            public IRubyObject create() {
                return DefaultRackApplicationFactory.this.createApplicationObject(runtime);
            }

            public Ruby runtime() {
                return runtime;
            }
        });
    }

    public void finishedWithApplication(RackApplication app) {
        app.destroy();
    }

    public RackApplication getErrorApplication(Ruby runtime) {
        if (this.errorApplication == null) {
            this.errorApplication = this.createErrorApp(runtime);
        }
        return this.errorApplication;
    }

    public void destroy() {
        if (this.errorApplication != null) {
            this.errorApplication.destroy();
        }
        this.errorApplication = null;
    }

    protected abstract IRubyObject createApplicationObject(Ruby var1);

    public IRubyObject createErrorApplicationObject(Ruby runtime) {
        return runtime.evalScriptlet("Rack::Handler::Grizzly.new(Rack::Builder.new {( run JRuby::Rack::ErrorsApp.new\n )}.to_app)");
    }

    private RackApplication createErrorApp(final Ruby runtime) {
        try {
            RackApplication app = this.createApplication(new ApplicationObjectFactory(){

                public IRubyObject create() {
                    return DefaultRackApplicationFactory.this.createErrorApplicationObject(runtime);
                }

                public Ruby runtime() {
                    return runtime;
                }
            });
            return app;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Warning: error application could not be initialized.");
            return new DefaultRackApplication(this.createErrorApplicationObject(runtime), this.adapter){

                public void init() throws RackInitializationException {
                }

                public RackResponse call(GrizzlyRequest env) {
                    return new RackResponse(){

                        public int getStatus() {
                            return 500;
                        }

                        public Map getHeaders() {
                            return Collections.EMPTY_MAP;
                        }

                        public String getBody() {
                            return "";
                        }

                        public void respond(GrizzlyResponse response) {
                            try {
                                response.sendError(500, "Application initialization failed: " + e.getMessage());
                            }
                            catch (IOException ex) {
                                DefaultRackApplicationFactory.this.logger.severe("Unable to send default error page!");
                            }
                        }
                    };
                }

                public void destroy() {
                    JavaEmbedUtils.terminate((Ruby)runtime);
                }
            };
        }
    }

    public RackApplication newErrorApplication(Ruby runtime) {
        if (this.errorApplication == null) {
            this.errorApplication = this.createErrorApp(runtime);
        }
        return this.errorApplication;
    }

    private RackApplication createApplication(final ApplicationObjectFactory appfact) throws RackInitializationException {
        try {
            return new DefaultRackApplication(appfact.create(), this.adapter){

                public void destroy() {
                    JavaEmbedUtils.terminate((Ruby)appfact.runtime());
                }
            };
        }
        catch (RaiseException re) {
            throw new RackInitializationException(re);
        }
    }

    private static interface ApplicationObjectFactory {
        public IRubyObject create();

        public Ruby runtime();
    }
}

