/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.jsftemplating.component.TemplateOutputComponentBase;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamerPhaseListener;
import com.sun.mojarra.scales.component.Links;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;

public class YuiChart
extends TemplateOutputComponentBase {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.YuiChart";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.YuiChart";
    protected String type = "line";
    protected String horizontalField;
    protected String verticalField;
    protected String horizontalAxis = "";
    protected String verticalAxis = "";
    protected String labelFunction = "";
    protected String categoryField;
    protected String dataField;
    protected String seriesDef = "[]";
    protected String width = "500px";
    protected String height = "250px";

    public YuiChart() {
        this.setRendererType("com.sun.mojarra.scales.YuiChart");
        this.setLayoutDefinitionKey("/templates/chart.xhtml");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/datasource/datasource-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/json/json-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/charts/charts-min.js"));
            Links.addScript("SCALES_DOM_READY_SCRIPTS", "YAHOO.widget.Chart.SWFURL = '" + baseUrl + FileStreamerPhaseListener.createResourceUrl((FacesContext)context, null, (String)"/yui/charts/assets/charts.swf") + "';");
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.YuiChart";
    }

    public static void scriptHandler(HandlerContext context) {
        List list;
        YuiChart chart = (YuiChart)((Object)context.getInputValue("chart"));
        Object chartValue = chart.getValue();
        StringBuilder script = new StringBuilder();
        String sep = "";
        String responseSchema = "";
        Set keys = null;
        if (chartValue instanceof List && (list = (List)chartValue).get(0) instanceof Map) {
            List mapList = list;
            for (Map map : mapList) {
                keys = map.keySet();
                String sep2 = "";
                Iterator iter = keys.iterator();
                script.append(sep).append("{");
                while (iter.hasNext()) {
                    Object key = iter.next();
                    String value = (String)map.get(key);
                    String quote = Character.isDigit(value.charAt(0)) ? "" : "\"";
                    script.append(sep2).append(key.toString()).append(": ").append(quote).append(map.get(key)).append(quote);
                    sep2 = ",";
                }
                script.append("}");
                sep = ",";
            }
        }
        responseSchema = YuiChart.buildSeriesDef(keys);
        context.setOutputValue("chart_data", (Object)script.toString());
        context.setOutputValue("chart_schema", (Object)responseSchema);
        context.setOutputValue("chart_config", YuiChart.prepareChartConfig(chart));
    }

    private static Object prepareChartConfig(YuiChart chart) {
        String chartType = chart.getType().toLowerCase();
        StringBuilder config = new StringBuilder();
        if ("column".equals(chartType)) {
            config.append("xField: \"").append(chart.getHorizontalField()).append("\", yField:\"").append(chart.getVerticalField()).append("\"");
        } else if ("stackedcolumn".equals(chartType)) {
            config.append("xField: \"").append(chart.getHorizontalField()).append("\", yField:\"").append(chart.getVerticalField()).append("\"");
        } else if ("line".equals(chartType)) {
            config.append("xField: \"").append(chart.getHorizontalField()).append("\"");
        } else if ("pie".equals(chartType)) {
            config.append("categoryField:\"").append(chart.getCategoryField()).append("\", dataField:\"").append(chart.getDataField()).append("\"");
            YuiChart.appendField(config, chart.getLabelFunction(), "labelFunction");
        } else if ("bar".equals(chartType)) {
            config.append("yField:\"").append(chart.getVerticalField()).append("\"");
        } else if ("stackedbar".equals(chartType)) {
            config.append("yField:\"").append(chart.getVerticalField()).append("\"");
        }
        YuiChart.appendField(config, chart.getSeriesDef(), "series");
        YuiChart.appendField(config, chart.getHorizontalAxis(), "xAxis");
        YuiChart.appendField(config, chart.getVerticalAxis(), "yAxis");
        return config.toString();
    }

    protected static void appendField(StringBuilder sb, String field, String fieldName) {
        if (field != null && !"".equals(field)) {
            sb.append(", ").append(fieldName).append(": ").append(field);
        }
    }

    protected static String buildSeriesDef(Set keys) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (keys != null) {
            for (Object key : keys) {
                sb.append(sep).append("\"").append(key.toString()).append("\"");
                sep = ",";
            }
        }
        return sb.toString();
    }

    public String getType() {
        return this.type.substring(0, 1).toUpperCase() + this.type.substring(1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCategoryField() {
        return (String)this.getPropertyValue(this.categoryField, "categoryField", null);
    }

    public void setCategoryField(String categoryField) {
        this.categoryField = categoryField;
    }

    public String getDataField() {
        return (String)this.getPropertyValue(this.dataField, "dataField", null);
    }

    public void setDataField(String dataField) {
        this.dataField = dataField;
    }

    public String getSeriesDef() {
        return (String)this.getPropertyValue(this.seriesDef, "seriesDef", "[{}]");
    }

    public void setSeriesDef(String seriesDef) {
        this.seriesDef = seriesDef;
    }

    public String getLabelFunction() {
        return (String)this.getPropertyValue(this.labelFunction, "horizontallabelFunctionAxis", "");
    }

    public void setLabelFunction(String labelFunction) {
        this.labelFunction = labelFunction;
    }

    public String getHorizontalAxis() {
        return (String)this.getPropertyValue(this.horizontalAxis, "horizontalAxis", "");
    }

    public void setHorizontalAxis(String horizontalAxis) {
        this.horizontalAxis = horizontalAxis;
    }

    public String getHorizontalField() {
        return (String)this.getPropertyValue(this.horizontalField, "horizontalField", null);
    }

    public void setHorizontalField(String horizontalField) {
        this.horizontalField = horizontalField;
    }

    public String getVerticalAxis() {
        return (String)this.getPropertyValue(this.verticalAxis, "verticalAxis", "");
    }

    public void setVerticalAxis(String verticalAxis) {
        this.verticalAxis = verticalAxis;
    }

    public String getVerticalField() {
        return (String)this.getPropertyValue(this.verticalField, "verticalField", null);
    }

    public void setVerticalField(String verticalField) {
        this.verticalField = verticalField;
    }

    public String getHeight() {
        return (String)this.getPropertyValue(this.height, "height", "250px");
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return (String)this.getPropertyValue(this.width, "width", "500px");
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public void setValue(Object value) {
        super.setValue(value);
    }
}

