/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.mojarra.scales.component.FileDownload;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = Logger.getLogger(DownloadPhaseListener.class.getName());

    public void beforePhase(PhaseEvent e) {
        FacesContext context;
        HttpServletRequest request;
        String uri;
        PhaseId phase = e.getPhaseId();
        if (phase == PhaseId.RENDER_RESPONSE && (uri = (request = (HttpServletRequest)(context = FacesContext.getCurrentInstance()).getExternalContext().getRequest()).getRequestURI()) != null && uri.indexOf("mojarra___Download") > -1) {
            try {
                Object value;
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                String clientId = request.getParameter("componentId");
                FileDownload comp = (FileDownload)((Object)request.getSession().getAttribute("HtmlDownload-" + clientId));
                if (comp != null && (value = comp.getData()) != null) {
                    byte[] data = null;
                    if (value instanceof byte[]) {
                        data = (byte[])value;
                    } else if (value instanceof ByteArrayOutputStream) {
                        data = ((ByteArrayOutputStream)value).toByteArray();
                    } else if (value instanceof InputStream) {
                        data = this.getBytes((InputStream)value);
                    } else {
                        throw new FacesException("HtmlDownload:  an unsupported data type was found:  " + value.getClass().getName());
                    }
                    String mimeType = comp.getMimeType();
                    if ("download".equals(comp.getMethod())) {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + comp.getFileName() + "\"");
                    } else {
                        response.setHeader("Content-Disposition", "inline; filename=\"" + comp.getFileName() + "\"");
                    }
                    response.setContentType(mimeType);
                    ServletOutputStream sos = response.getOutputStream();
                    sos.write(data);
                    sos.flush();
                    request.getSession().setAttribute("HtmlDownload-" + clientId, null);
                    context.responseComplete();
                }
            }
            catch (IOException e1) {
                this.logger.severe(e1.getMessage());
                e1.printStackTrace();
            }
        }
    }

    public void afterPhase(PhaseEvent e) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int count = 0;
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer)) != -1) {
                if (count <= 0) continue;
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }
}

