/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.Context;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class FileDownloadContentSource
implements ContentSource {
    public static final String CONTENT_SOURCE_ID = "fileDownloadCs";

    public String getId() {
        return CONTENT_SOURCE_ID;
    }

    public InputStream getInputStream(Context context) throws IOException {
        InputStream in = (InputStream)context.getAttribute("inputStream");
        if (in != null) {
            return in;
        }
        String componentId = (String)context.getAttribute("filePath");
        FacesContext fc = FacesContext.getCurrentInstance();
        Map downloadData = (Map)fc.getExternalContext().getSessionMap().get("HtmlDownload-" + componentId);
        if (downloadData != null) {
            Object value;
            String fileName = (String)downloadData.get("filename");
            String extension = null;
            if (fileName != null && !"".equals(fileName)) {
                context.setAttribute("filename", (Object)fileName);
                extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            if ((value = downloadData.get("data")) != null) {
                String mimeType = (String)downloadData.get("mimetype");
                if (mimeType == null && extension != null) {
                    mimeType = FileStreamer.getMimeType((String)extension);
                }
                if (mimeType == null) {
                    mimeType = "text/plain";
                }
                context.setAttribute("ContentType", (Object)mimeType);
                String method = (String)downloadData.get("method");
                if ("download".equals(method)) {
                    context.setAttribute("disposition", (Object)("download".equalsIgnoreCase(method) ? "attachment" : "inline"));
                } else {
                    context.setAttribute("disposition", (Object)"inline");
                }
                if (value instanceof byte[]) {
                    in = new ByteArrayInputStream((byte[])value);
                } else if (value instanceof ByteArrayOutputStream) {
                    in = new ByteArrayInputStream(((ByteArrayOutputStream)value).toByteArray());
                } else if (value instanceof InputStream) {
                    in = (InputStream)value;
                } else {
                    try {
                        in = new ByteArrayInputStream(value.toString().getBytes());
                    }
                    catch (Exception e) {
                        throw new FacesException("HtmlDownload:  an unsupported data type was found:  " + value.getClass().getName());
                    }
                }
            }
            ((HttpServletRequest)fc.getExternalContext().getRequest()).setAttribute("HtmlDownload-" + componentId, null);
        } else {
            context.setAttribute("ContentType", (Object)"text/plain");
            context.setAttribute("disposition", (Object)"inline");
            in = new ByteArrayInputStream("The item requested was either not found or has been previously accessed and cleared from the session.".getBytes());
        }
        context.setAttribute("inputStream", (Object)in);
        return in;
    }

    public void cleanUp(Context context) {
        InputStream is = (InputStream)context.getAttribute("inputStream");
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        context.removeAttribute("inputStream");
    }

    public long getLastModified(Context context) {
        return -1L;
    }
}

