/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-connector-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.connection.pool")
public class CreateConnectorConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateConnectorConnectionPool.class);
    @Param(name="raname")
    String raname;
    @Param(name="connectiondefinition", optional=true)
    String connectiondefinition;
    @Param(name="steadypoolsize", optional=true)
    String steadypoolsize = "8";
    @Param(name="maxpoolsize", optional=true)
    String maxpoolsize = "32";
    @Param(name="maxwait", optional=true)
    String maxwait = "60000";
    @Param(name="poolresize", optional=true)
    String poolresize = "2";
    @Param(name="idletimeout", optional=true)
    String idletimeout = "300";
    @Param(name="isconnectvalidatereq", optional=true, defaultValue="false")
    Boolean isconnectvalidatereq;
    @Param(name="failconnection", optional=true, defaultValue="false")
    Boolean failconnection;
    @Param(name="leaktimeout", optional=true)
    String leaktimeout = "0";
    @Param(name="leakreclaim", optional=true, defaultValue="false")
    Boolean leakreclaim;
    @Param(name="creationretryattempts", optional=true)
    String creationretryattempts = "0";
    @Param(name="creationretryinterval", optional=true)
    String creationretryinterval = "10";
    @Param(name="lazyconnectionenlistment", optional=true, defaultValue="false")
    Boolean lazyconnectionenlistment;
    @Param(name="lazyconnectionassociation", optional=true, defaultValue="false")
    Boolean lazyconnectionassociation;
    @Param(name="associatewiththread", optional=true, defaultValue="false")
    Boolean associatewiththread;
    @Param(name="matchconnections", optional=true, defaultValue="false")
    Boolean matchconnections;
    @Param(name="maxconnectionusagecount", optional=true)
    String maxconnectionusagecount = "0";
    @Param(name="validateatmostonceperiod", optional=true)
    String validateatmostonceperiod;
    @Param(name="transactionsupport", acceptableValues="XATransaction,LocalTransaction,NoTransaction", optional=true)
    String transactionsupport;
    @Param(name="description", optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="poolname", primary=true)
    String poolname;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (this.poolname == null) {
            report.setMessage(localStrings.getLocalString("create.connector.connection.pool.noJndiName", "No pool name defined for connector connection pool."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)resource).getName().equals(this.poolname)) continue;
            report.setMessage(localStrings.getLocalString("create.connector.connection.pool.duplicate", "A connector connection pool named {0} already exists.", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorConnectionPool newResource = (ConnectorConnectionPool)param.createChild(ConnectorConnectionPool.class);
                    newResource.setPoolResizeQuantity(CreateConnectorConnectionPool.this.poolresize);
                    newResource.setMaxWaitTimeInMillis(CreateConnectorConnectionPool.this.maxwait);
                    newResource.setMaxPoolSize(CreateConnectorConnectionPool.this.maxpoolsize);
                    newResource.setSteadyPoolSize(CreateConnectorConnectionPool.this.steadypoolsize);
                    newResource.setIsConnectionValidationRequired(CreateConnectorConnectionPool.this.isconnectvalidatereq.toString());
                    newResource.setIdleTimeoutInSeconds(CreateConnectorConnectionPool.this.idletimeout);
                    newResource.setFailAllConnections(CreateConnectorConnectionPool.this.failconnection.toString());
                    if (CreateConnectorConnectionPool.this.raname != null) {
                        newResource.setResourceAdapterName(CreateConnectorConnectionPool.this.raname);
                    }
                    newResource.setConnectionDefinitionName(CreateConnectorConnectionPool.this.connectiondefinition);
                    newResource.setConnectionLeakTimeoutInSeconds(CreateConnectorConnectionPool.this.leaktimeout);
                    newResource.setConnectionLeakReclaim(CreateConnectorConnectionPool.this.leakreclaim.toString());
                    newResource.setConnectionCreationRetryIntervalInSeconds(CreateConnectorConnectionPool.this.creationretryinterval);
                    newResource.setConnectionCreationRetryAttempts(CreateConnectorConnectionPool.this.creationretryattempts);
                    newResource.setLazyConnectionAssociation(CreateConnectorConnectionPool.this.lazyconnectionassociation.toString());
                    newResource.setLazyConnectionEnlistment(CreateConnectorConnectionPool.this.lazyconnectionenlistment.toString());
                    newResource.setMatchConnections(CreateConnectorConnectionPool.this.matchconnections.toString());
                    newResource.setMaxConnectionUsageCount(CreateConnectorConnectionPool.this.maxconnectionusagecount);
                    newResource.setValidateAtmostOncePeriodInSeconds(CreateConnectorConnectionPool.this.validateatmostonceperiod);
                    newResource.setAssociateWithThread(CreateConnectorConnectionPool.this.associatewiththread.toString());
                    newResource.setTransactionSupport(CreateConnectorConnectionPool.this.transactionsupport);
                    if (CreateConnectorConnectionPool.this.description != null) {
                        newResource.setDescription(CreateConnectorConnectionPool.this.description);
                    }
                    newResource.setName(CreateConnectorConnectionPool.this.poolname);
                    if (CreateConnectorConnectionPool.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateConnectorConnectionPool.this.properties.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)this.resources);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.connector.connection.pool.fail", "Connector connection pool {0} create failed: {1}", new Object[]{this.poolname}) + " " + tfe.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("create.connector.connection.pool.success", "Connector connection pool {0} created successfully", new Object[]{this.poolname}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

