/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.EventObject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.Record;

public class DescriptorEvent
extends EventObject {
    protected int eventCode;
    protected DatabaseQuery query;
    protected Record record;
    protected ClassDescriptor descriptor;
    protected Object originalObject;
    protected ObjectChangeSet changeSet;
    protected AbstractSession session;
    protected static String[] eventNames = new String[18];

    public DescriptorEvent(int n, ObjectLevelModifyQuery objectLevelModifyQuery) {
        this(objectLevelModifyQuery.getObject());
        this.query = objectLevelModifyQuery;
        this.eventCode = n;
        this.session = objectLevelModifyQuery.getSession();
        this.descriptor = objectLevelModifyQuery.getDescriptor();
    }

    public DescriptorEvent(Object object) {
        super(object);
    }

    public void applyAttributeValuesIntoRow(String string) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(this.getSource());
        DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw ValidationException.missingMappingForAttribute(classDescriptor, string, this.toString());
        }
        if (this.getRecord() != null) {
            databaseMapping.writeFromObjectIntoRow(this.getSource(), (AbstractRecord)this.getRecord(), this.getSession());
        }
    }

    public ObjectChangeSet getChangeSet() {
        return this.changeSet;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.descriptor;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Object getObject() {
        return this.getSource();
    }

    public Object getOriginalObject() {
        if (this.originalObject == null && this.getSession().isUnitOfWork() && this.getQuery() != null && this.getQuery().isObjectLevelModifyQuery()) {
            this.setOriginalObject(((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(this.getSource()));
        }
        return this.originalObject;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Record getRecord() {
        return this.record;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setChangeSet(ObjectChangeSet objectChangeSet) {
        this.changeSet = objectChangeSet;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setEventCode(int n) {
        this.eventCode = n;
    }

    public void setOriginalObject(Object object) {
        this.originalObject = object;
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public String toString() {
        String string = "UnkownEvent";
        if (this.getEventCode() >= 0 && this.getEventCode() < 18) {
            string = eventNames[this.getEventCode()];
        }
        return string + "(" + this.getSource().getClass() + ")";
    }

    public void updateAttributeWithObject(String string, Object object) {
        ClassDescriptor classDescriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object2 = this.getObject();
        Object object3 = object;
        Object object4 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object4 = this.getOriginalObject();
        }
        Object object5 = object;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object6 = object;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object2 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((classDescriptor = this.getSession().getDescriptor(object.getClass())) != null) {
            if (objectChangeSet != null) {
                object6 = classDescriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object4 != null) {
                object5 = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(object);
            }
        }
        if (object2 != null) {
            databaseMapping.setRealAttributeValueInObject(object2, object3);
        }
        if (object4 != null) {
            databaseMapping.setRealAttributeValueInObject(object4, object5);
        }
        if (this.getRecord() != null) {
            AbstractRecord abstractRecord = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            databaseMapping.writeFromObjectIntoRow(object2, abstractRecord, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom(abstractRecord);
        }
        if (objectChangeSet != null) {
            objectChangeSet.removeChange(string);
            objectChangeSet.addChange(databaseMapping.compareForChange(object2, ((UnitOfWorkImpl)this.getSession()).getBackupClone(object2, this.getDescriptor()), objectChangeSet, this.getSession()));
        }
    }

    public void updateAttributeAddObjectToCollection(String string, Object object, Object object2) {
        Object object3;
        ClassDescriptor classDescriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object4 = this.getObject();
        Object object5 = object2;
        Object object6 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object6 = this.getOriginalObject();
        }
        Object object7 = object2;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object8 = object2;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object4 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((classDescriptor = this.getSession().getDescriptor(object2.getClass())) != null) {
            if (objectChangeSet != null) {
                object8 = classDescriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object6 != null) {
                object7 = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(object2);
            }
        }
        if (object4 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object4, this.getSession());
            databaseMapping.getContainerPolicy().addInto(object, object5, object3, this.getSession());
        }
        if (object6 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object6, this.getSession());
            databaseMapping.getContainerPolicy().addInto(object, object7, object3, this.getSession());
        }
        if (this.getRecord() != null) {
            object3 = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            databaseMapping.writeFromObjectIntoRow(object4, (AbstractRecord)object3, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom((AbstractRecord)object3);
        }
        if (objectChangeSet != null) {
            databaseMapping.simpleAddToCollectionChangeRecord(object, object8, objectChangeSet, this.getSession());
        }
    }

    public void updateAttributeRemoveObjectFromCollection(String string, Object object, Object object2) {
        Object object3;
        ClassDescriptor classDescriptor;
        DatabaseMapping databaseMapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(string, this.getDescriptor());
        }
        Object object4 = this.getObject();
        Object object5 = object2;
        Object object6 = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            object6 = this.getOriginalObject();
        }
        Object object7 = object2;
        ObjectChangeSet objectChangeSet = this.getChangeSet();
        Object object8 = object2;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            object4 = ((ObjectLevelModifyQuery)this.query).getObject();
            objectChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((classDescriptor = this.getSession().getDescriptor(object2.getClass())) != null) {
            if (objectChangeSet != null) {
                object8 = classDescriptor.getObjectBuilder().createObjectChangeSet(object2, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (object6 != null) {
                object7 = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(object2);
            }
        }
        if (object4 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object4, this.getSession());
            databaseMapping.getContainerPolicy().removeFrom(object, object5, object3, this.getSession());
        }
        if (object6 != null) {
            object3 = databaseMapping.getRealCollectionAttributeValueFromObject(object6, this.getSession());
            databaseMapping.getContainerPolicy().removeFrom(object, object7, object3, this.getSession());
        }
        if (this.getRecord() != null) {
            object3 = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            databaseMapping.writeFromObjectIntoRow(object4, (AbstractRecord)object3, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom((AbstractRecord)object3);
        }
        if (objectChangeSet != null) {
            databaseMapping.simpleRemoveFromCollectionChangeRecord(object, object8, objectChangeSet, this.getSession());
        }
    }

    static {
        DescriptorEvent.eventNames[0] = "PreWriteEvent";
        DescriptorEvent.eventNames[1] = "PostWriteEvent";
        DescriptorEvent.eventNames[2] = "PostDeleteEvent";
        DescriptorEvent.eventNames[3] = "PostDeleteEvent";
        DescriptorEvent.eventNames[4] = "PreInsertEvent";
        DescriptorEvent.eventNames[5] = "PostInsertEvent";
        DescriptorEvent.eventNames[6] = "PreUpdateEvent";
        DescriptorEvent.eventNames[7] = "PostUpdateEvent";
        DescriptorEvent.eventNames[8] = "PostBuildEvent";
        DescriptorEvent.eventNames[9] = "PostRefreshEvent";
        DescriptorEvent.eventNames[10] = "PostCloneEvent";
        DescriptorEvent.eventNames[11] = "PostMergeEvent";
        DescriptorEvent.eventNames[12] = "AboutToInsertEvent";
        DescriptorEvent.eventNames[13] = "AboutToUpdateEvent";
    }
}

