/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateObjectChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ObjectChangeTrackingPolicy
extends DeferredChangeDetectionPolicy {
    public void dissableEventProcessing(Object object) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (objectChangeListener != null) {
            objectChangeListener.ignoreEvents();
        }
    }

    public void enableEventProcessing(Object object) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (objectChangeListener != null) {
            objectChangeListener.processEvents();
        }
    }

    public boolean shouldCompareExistingObjectForChange(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (objectChangeListener != null && objectChangeListener.hasChanges()) {
            return true;
        }
        Boolean bl = null;
        if (unitOfWorkImpl.hasOptimisticReadLockObjects() && (bl = (Boolean)unitOfWorkImpl.getOptimisticReadLockObjects().get(object)) != null) {
            return true;
        }
        return classDescriptor.getCMPPolicy() != null && classDescriptor.getCMPPolicy().getForceUpdate();
    }

    public void raiseInternalPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (objectChangeListener != null) {
            objectChangeListener.internalPropertyChange(new PropertyChangeEvent(object, string, object2, object3));
        }
    }

    public void setAggregateChangeListener(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, String string) {
        ((ChangeTracker)object2)._persistence_setPropertyChangeListener(new AggregateObjectChangeListener((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener(), string));
    }

    public PropertyChangeListener setChangeListener(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        ObjectChangeListener objectChangeListener = new ObjectChangeListener();
        ((ChangeTracker)object)._persistence_setPropertyChangeListener(objectChangeListener);
        return objectChangeListener;
    }

    public void clearChanges(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (objectChangeListener != null) {
            objectChangeListener.clearChanges();
        } else {
            objectChangeListener = (ObjectChangeListener)this.setChangeListener(object, unitOfWorkImpl, classDescriptor);
        }
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        if (!objectBuilder.isSimple()) {
            this.dissableEventProcessing(object);
            FetchGroupManager fetchGroupManager = classDescriptor.getFetchGroupManager();
            boolean bl = fetchGroupManager != null && fetchGroupManager.isPartialObject(object);
            List<DatabaseMapping> list = objectBuilder.getRelationshipMappings();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = list.get(i);
                if (bl && !fetchGroupManager.isAttributeFetched(object, databaseMapping.getAttributeName())) continue;
                databaseMapping.setChangeListener(object, objectChangeListener, unitOfWorkImpl);
            }
            this.enableEventProcessing(object);
        }
    }

    public void initialize(AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        Class clazz = classDescriptor.getJavaClass();
        if (!ChangeTracker.class.isAssignableFrom(clazz)) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.needToImplementChangeTracker(classDescriptor));
        }
    }

    public boolean isDeferredChangeDetectionPolicy() {
        return false;
    }

    public boolean isObjectChangeTrackingPolicy() {
        return true;
    }
}

