/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions.spatial;

import java.io.StringWriter;

public class SpatialParameters {
    private String params = null;
    private Number minResolution = null;
    private Number maxResolution = null;
    private Units units = null;
    private Number distance = null;
    private QueryType queryType = null;
    private Mask[] masks = null;
    private static String UNIT_PARAM = "UNIT=";
    private static String MAX_RES_PARAM = "MAX_RESOLUTION=";
    private static String MIN_RES_PARAM = "MIN_RESOLUTION=";
    private static String DISTANCE_PARAM = "DISTANCE=";
    private static String QUERYTYPE_PARAM = "QUERYTYPE=";
    private static String MASK_PARAM = "MASK=";

    public SpatialParameters() {
    }

    public SpatialParameters(String string) {
        this.setParams(string);
    }

    public SpatialParameters setParams(String string) {
        this.params = string;
        return this;
    }

    public String getParams() {
        return this.params;
    }

    public SpatialParameters setMinResolution(Number number) {
        this.minResolution = number;
        return this;
    }

    public Number getMinResolution() {
        return this.minResolution;
    }

    public SpatialParameters setMaxResolution(Number number) {
        this.maxResolution = number;
        return this;
    }

    public Number getMaxResolution() {
        return this.maxResolution;
    }

    public SpatialParameters setUnits(Units units) {
        this.units = units;
        return this;
    }

    public Units getUnits() {
        return this.units;
    }

    public SpatialParameters setDistance(Number number) {
        this.distance = number;
        return this;
    }

    public Number getDistance() {
        return this.distance;
    }

    public SpatialParameters setQueryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public SpatialParameters setMasks(Mask[] maskArray) {
        this.masks = maskArray;
        return this;
    }

    public SpatialParameters setMask(Mask mask) {
        this.masks = new Mask[]{mask};
        return this;
    }

    public Mask[] getMasks() {
        return this.masks;
    }

    public String getParameterString() {
        if (this.getParams() != null) {
            return this.getParams();
        }
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        bl = this.writeParam(stringWriter, DISTANCE_PARAM, this.getDistance(), bl);
        bl = this.writeParam(stringWriter, MAX_RES_PARAM, this.getMaxResolution(), bl);
        bl = this.writeParam(stringWriter, MIN_RES_PARAM, this.getMinResolution(), bl);
        bl = this.writeParam(stringWriter, UNIT_PARAM, (Object)this.getUnits(), bl);
        bl = this.writeParam(stringWriter, MASK_PARAM, this.getMasks(), bl);
        bl = this.writeParam(stringWriter, QUERYTYPE_PARAM, (Object)this.getQueryType(), bl);
        return bl ? stringWriter.toString() : null;
    }

    private boolean writeParam(StringWriter stringWriter, String string, Object object, boolean bl) {
        if (object != null) {
            if (bl) {
                stringWriter.write(" ");
            }
            if (object.getClass().isArray()) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length == 0) {
                    return false;
                }
                stringWriter.write(string);
                stringWriter.write(objectArray[0].toString());
                for (int i = 1; i < objectArray.length; ++i) {
                    stringWriter.write("+");
                    stringWriter.write(objectArray[i].toString());
                }
            } else {
                stringWriter.write(string);
                stringWriter.write(object.toString());
            }
            return true;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mask {
        TOUCH,
        OVERLAPBDYDISJOINT,
        OVERLAPBDYINTERSECT,
        EQUAL,
        INSIDE,
        COVEREDBY,
        CONTAINS,
        COVERS,
        ANYINTERACT,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        WINDOW,
        JOIN,
        FILTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Units {
        M,
        KM,
        CM,
        MM,
        MILE,
        NAUT_MILE,
        FOOT,
        INCH;

    }
}

