/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class DescriptorIterator {
    public static final int NoCascading = 1;
    public static final int CascadePrivateParts = 2;
    public static final int CascadeAllParts = 3;
    protected Map visitedObjects = new IdentityHashMap();
    protected Stack visitedStack = new Stack();
    protected AbstractSession session;
    protected DatabaseMapping currentMapping;
    protected ClassDescriptor currentDescriptor;
    protected Object result;
    protected boolean shouldIterateOverIndirectionObjects = true;
    protected boolean shouldIterateOverUninstantiatedIndirectionObjects = false;
    protected boolean shouldIterateOverWrappedObjects = true;
    protected boolean shouldIterateOnIndirectionObjects = false;
    protected boolean shouldIterateOnAggregates = false;
    protected boolean shouldIterateOnPrimitives = false;
    protected boolean shouldBreak = false;
    protected int cascadeDepth = 3;

    public int getCascadeDepth() {
        return this.cascadeDepth;
    }

    public ClassDescriptor getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public DatabaseMapping getCurrentMapping() {
        return this.currentMapping;
    }

    protected ClassDescriptor getDescriptorFor(Object object) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        if (classDescriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().getName());
        }
        return classDescriptor;
    }

    public Object getResult() {
        return this.result;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getVisitedGrandparent() {
        Object e = this.getVisitedStack().pop();
        Object e2 = this.getVisitedStack().peek();
        this.getVisitedStack().push(e);
        return e2;
    }

    public Map getVisitedObjects() {
        return this.visitedObjects;
    }

    public Object getVisitedParent() {
        return this.getVisitedStack().peek();
    }

    public Stack getVisitedStack() {
        return this.visitedStack;
    }

    protected void internalIterateAggregateObject(Object object) {
        this.iterate(object);
    }

    protected void internalIterateIndirectContainer(IndirectContainer indirectContainer) {
        this.iterate(indirectContainer);
    }

    protected void internalIteratePrimitive(Object object) {
        this.iterate(object);
    }

    protected void internalIterateReferenceObject(Object object) {
        this.iterate(object);
    }

    protected void internalIterateValueHolder(ValueHolderInterface valueHolderInterface) {
        this.iterate(valueHolderInterface);
    }

    protected abstract void iterate(Object var1);

    public void iterateForAggregateMapping(Object object, DatabaseMapping databaseMapping, ClassDescriptor classDescriptor) {
        if (object == null) {
            return;
        }
        this.setCurrentMapping(databaseMapping);
        this.setCurrentDescriptor(classDescriptor);
        if (this.shouldIterateOnAggregates()) {
            this.internalIterateAggregateObject(object);
            if (this.shouldBreak()) {
                this.setShouldBreak(false);
                return;
            }
        }
        this.iterateReferenceObjects(object);
    }

    public void iterateIndirectContainerForMapping(IndirectContainer indirectContainer, DatabaseMapping databaseMapping) {
        this.setCurrentMapping(databaseMapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateIndirectContainer(indirectContainer);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && indirectContainer.isInstantiated()) {
            databaseMapping.iterateOnRealAttributeValue(this, indirectContainer);
        } else if (this.shouldIterateOverIndirectionObjects() && indirectContainer instanceof IndirectCollection) {
            databaseMapping.iterateOnRealAttributeValue(this, ((IndirectCollection)indirectContainer).getAddedElements());
        }
    }

    public void iteratePrimitiveForMapping(Object object, DatabaseMapping databaseMapping) {
        if (object == null) {
            return;
        }
        this.setCurrentMapping(databaseMapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnPrimitives()) {
            this.internalIteratePrimitive(object);
        }
    }

    public void iterateReferenceObjectForMapping(Object object, DatabaseMapping databaseMapping) {
        if (!(this.shouldCascadeAllParts() || this.shouldCascadePrivateParts() && databaseMapping.isPrivateOwned())) {
            return;
        }
        ClassDescriptor classDescriptor = databaseMapping.getReferenceDescriptor();
        if (!this.shouldIterateOverWrappedObjects() && classDescriptor != null && classDescriptor.hasWrapperPolicy()) {
            return;
        }
        if (object == null) {
            return;
        }
        if (this.getVisitedObjects().containsKey(object)) {
            return;
        }
        this.getVisitedObjects().put(object, object);
        this.setCurrentMapping(databaseMapping);
        this.setCurrentDescriptor(this.getDescriptorFor(object));
        this.internalIterateReferenceObject(object);
        if (this.shouldBreak()) {
            this.setShouldBreak(false);
            return;
        }
        this.iterateReferenceObjects(object);
    }

    protected void iterateReferenceObjects(Object object) {
        this.getVisitedStack().push(object);
        this.getCurrentDescriptor().getObjectBuilder().iterate(this);
        this.getVisitedStack().pop();
    }

    public void iterateValueHolderForMapping(ValueHolderInterface valueHolderInterface, DatabaseMapping databaseMapping) {
        this.setCurrentMapping(databaseMapping);
        this.setCurrentDescriptor(null);
        if (this.shouldIterateOnIndirectionObjects()) {
            this.internalIterateValueHolder(valueHolderInterface);
        }
        if (this.shouldIterateOverUninstantiatedIndirectionObjects() || this.shouldIterateOverIndirectionObjects() && valueHolderInterface.isInstantiated()) {
            databaseMapping.iterateOnRealAttributeValue(this, valueHolderInterface.getValue());
        }
    }

    public void setCascadeDepth(int n) {
        this.cascadeDepth = n;
    }

    public void setCurrentDescriptor(ClassDescriptor classDescriptor) {
        this.currentDescriptor = classDescriptor;
    }

    public void setCurrentMapping(DatabaseMapping databaseMapping) {
        this.currentMapping = databaseMapping;
    }

    public void setResult(Object object) {
        this.result = object;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setShouldBreak(boolean bl) {
        this.shouldBreak = bl;
    }

    public void setShouldIterateOnAggregates(boolean bl) {
        this.shouldIterateOnAggregates = bl;
    }

    public void setShouldIterateOnIndirectionObjects(boolean bl) {
        this.shouldIterateOnIndirectionObjects = bl;
    }

    public void setShouldIterateOnPrimitives(boolean bl) {
        this.shouldIterateOnPrimitives = bl;
    }

    public void setShouldIterateOverIndirectionObjects(boolean bl) {
        this.shouldIterateOverIndirectionObjects = bl;
    }

    public void setShouldIterateOverUninstantiatedIndirectionObjects(boolean bl) {
        this.shouldIterateOverUninstantiatedIndirectionObjects = bl;
    }

    public void setShouldIterateOverWrappedObjects(boolean bl) {
        this.shouldIterateOverWrappedObjects = bl;
    }

    public void setVisitedObjects(Map map) {
        this.visitedObjects = map;
    }

    protected void setVisitedStack(Stack stack) {
        this.visitedStack = stack;
    }

    public boolean shouldBreak() {
        return this.shouldBreak;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadeDepth() == 3;
    }

    public boolean shouldCascadeNoParts() {
        return this.getCascadeDepth() == 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadeDepth() == 3 || this.getCascadeDepth() == 2;
    }

    public boolean shouldIterateOnAggregates() {
        return this.shouldIterateOnAggregates;
    }

    public boolean shouldIterateOnIndirectionObjects() {
        return this.shouldIterateOnIndirectionObjects;
    }

    public boolean shouldIterateOnPrimitives() {
        return this.shouldIterateOnPrimitives;
    }

    public boolean shouldIterateOverIndirectionObjects() {
        return this.shouldIterateOverIndirectionObjects;
    }

    public boolean shouldIterateOverUninstantiatedIndirectionObjects() {
        return this.shouldIterateOverUninstantiatedIndirectionObjects;
    }

    public boolean shouldIterateOverWrappedObjects() {
        return this.shouldIterateOverWrappedObjects;
    }

    public void startIterationOn(Object object) {
        if (this.getVisitedObjects().containsKey(object)) {
            return;
        }
        this.getVisitedObjects().put(object, object);
        this.setCurrentMapping(null);
        this.setCurrentDescriptor(this.getSession().getDescriptor(object));
        this.iterate(object);
        if (this.getCurrentDescriptor() != null && !this.shouldCascadeNoParts() && !this.shouldBreak()) {
            this.iterateReferenceObjects(object);
        }
    }
}

