/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodReturnType;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName;
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getGetMethod(), object, null));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), exception);
                    }
                    throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), exception);
                }
            }
            return this.getMethod.invoke(object, (Object[])null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), object.getClass().getName(), nullPointerException);
        }
    }

    protected Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class getGetMethodReturnType() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedGetMethodReturnType(this.getGetMethod()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodReturnType(this.getGetMethod());
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class getSetMethodParameterType() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return ((Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.getSetMethod())))[0];
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodParameterTypes(this.getSetMethod())[0];
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(clazz, this.getGetMethodName(), null));
            Class[] classArray = new Class[]{this.getGetMethodReturnType()};
            this.setSetMethod(Helper.getDeclaredMethod(clazz, this.getSetMethodName(), classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), clazz.getName());
            descriptorException.setInternalException(noSuchMethodException);
            throw descriptorException;
        }
        catch (SecurityException securityException) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), clazz.getName());
            descriptorException.setInternalException(securityException);
            throw descriptorException;
        }
    }

    public boolean isInitialized() {
        return this.getMethod != null && this.setMethod != null;
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        block24: {
            Object[] objectArray = new Object[]{object2};
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), object, objectArray));
                        break block24;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, exception);
                        }
                        throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, exception);
                    }
                }
                this.setMethod.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    if (object2 instanceof String) {
                        Object object3 = ConversionManager.getDefaultManager().convertObject(object2, this.getAttributeClass());
                        Object[] objectArray2 = new Object[]{object3};
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), object, objectArray2));
                            }
                            catch (PrivilegedActionException privilegedActionException) {}
                        } else {
                            PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), object, objectArray2);
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), object2, invocationTargetException);
            }
            catch (NullPointerException nullPointerException) {
                try {
                    Class clazz = this.getSetMethodParameterType();
                    if (clazz.isPrimitive() && object2 == null) {
                        objectArray[0] = ConversionManager.getDefaultManager().convertObject(new Integer(0), clazz);
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), object, objectArray));
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                Exception exception = privilegedActionException.getException();
                                if (exception instanceof IllegalAccessException) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, exception);
                                }
                                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, exception);
                            }
                        }
                        PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), object, objectArray);
                    }
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), object2, nullPointerException);
                }
            }
        }
    }

    protected void setGetMethod(Method method) {
        this.getMethod = method;
    }

    public void setGetMethodName(String string) {
        this.getMethodName = string;
    }

    protected void setSetMethod(Method method) {
        this.setMethod = method;
    }

    public void setSetMethodName(String string) {
        this.setMethodName = string;
    }
}

