/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import javax.jms.Connection;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSAdapterMetaData;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnection;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSRecordFactory;

public class CciJMSConnectionFactory
implements ConnectionFactory {
    public javax.resource.cci.Connection getConnection() throws EISException {
        return this.getConnection(new CciJMSConnectionSpec());
    }

    public javax.resource.cci.Connection getConnection(ConnectionSpec connectionSpec) throws EISException {
        CciJMSConnectionSpec cciJMSConnectionSpec = null;
        QueueSession queueSession = null;
        QueueConnection queueConnection = null;
        try {
            javax.jms.ConnectionFactory connectionFactory;
            cciJMSConnectionSpec = (CciJMSConnectionSpec)connectionSpec;
            if (cciJMSConnectionSpec.hasConnectionFactoryURL()) {
                connectionFactory = (javax.jms.ConnectionFactory)new InitialContext().lookup(cciJMSConnectionSpec.getConnectionFactoryURL());
            } else {
                connectionFactory = cciJMSConnectionSpec.getConnectionFactory();
                if (connectionFactory == null) {
                    throw EISException.noConnectionFactorySpecified();
                }
            }
            queueConnection = cciJMSConnectionSpec.hasUsername() ? ((QueueConnectionFactory)connectionFactory).createQueueConnection(cciJMSConnectionSpec.getUsername(), cciJMSConnectionSpec.getPassword()) : ((QueueConnectionFactory)connectionFactory).createQueueConnection();
            queueConnection.start();
            queueSession = queueConnection.createQueueSession(true, 1);
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
        return new CciJMSConnection((Session)queueSession, (Connection)queueConnection, cciJMSConnectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new CciJMSAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new CciJMSRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

