/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLDeleteAllStatement
extends SQLDeleteStatement {
    protected Expression inheritanceExpression;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected SQLCall selectCallForNotExist;
    protected String tableAliasInSelectCallForNotExist;
    protected Vector aliasedFields;
    protected Vector originalFields;
    protected boolean shouldExtractWhereClauseFromSelectCallForExist;

    public void setSelectCallForExist(SQLCall sQLCall) {
        this.selectCallForExist = sQLCall;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setSelectCallForNotExist(SQLCall sQLCall) {
        this.selectCallForNotExist = sQLCall;
    }

    public SQLCall getSelectCallForNotExist() {
        return this.selectCallForNotExist;
    }

    public void setTableAliasInSelectCallForExist(String string) {
        this.tableAliasInSelectCallForExist = string;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setTableAliasInSelectCallForNotExist(String string) {
        this.tableAliasInSelectCallForNotExist = string;
    }

    public String getTableAliasInSelectCallForNotExist() {
        return this.tableAliasInSelectCallForNotExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection collection) {
        if (collection != null) {
            if (collection instanceof Vector) {
                this.setOriginalFieldsForJoin((Vector)collection);
            } else {
                this.setOriginalFieldsForJoin(new Vector(collection));
            }
            this.setAliasedFieldsForJoin((Vector)this.getOriginalFieldsForJoin().clone());
        } else {
            this.setOriginalFieldsForJoin(null);
            this.setAliasedFieldsForJoin(null);
        }
    }

    public void setOriginalFieldsForJoin(Vector vector) {
        this.originalFields = vector;
    }

    public Vector getOriginalFieldsForJoin() {
        return this.originalFields;
    }

    public void setAliasedFieldsForJoin(Vector vector) {
        this.aliasedFields = vector;
    }

    public Vector getAliasedFieldsForExpression() {
        return this.aliasedFields;
    }

    public void setInheritanceExpression(Expression expression) {
        this.inheritanceExpression = expression;
    }

    public Expression getInheritanceExpression() {
        return this.inheritanceExpression;
    }

    public void setShouldExtractWhereClauseFromSelectCallForExist(boolean bl) {
        this.shouldExtractWhereClauseFromSelectCallForExist = bl;
    }

    public boolean shouldExtractWhereClauseFromSelectCallForExist() {
        return this.shouldExtractWhereClauseFromSelectCallForExist;
    }

    public DatabaseCall buildCall(AbstractSession abstractSession) {
        SQLCall sQLCall = (SQLCall)super.buildCall(abstractSession);
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        try {
            charArrayWriter.write(sQLCall.getSQLString());
            boolean bl = true;
            if (this.selectCallForExist != null) {
                if (this.shouldExtractWhereClauseFromSelectCallForExist) {
                    bl = this.writeWhere(charArrayWriter, this.selectCallForExist, sQLCall);
                } else {
                    charArrayWriter.write(" WHERE EXISTS(");
                    this.writeSelect(charArrayWriter, this.selectCallForExist, this.tableAliasInSelectCallForExist, sQLCall);
                    charArrayWriter.write(")");
                }
            } else if (this.inheritanceExpression != null) {
                charArrayWriter.write(" WHERE ");
                ExpressionSQLPrinter expressionSQLPrinter = new ExpressionSQLPrinter(abstractSession, this.getTranslationRow(), sQLCall, false);
                expressionSQLPrinter.setWriter(charArrayWriter);
                expressionSQLPrinter.printExpression(this.inheritanceExpression);
            } else {
                bl = false;
            }
            if (this.selectCallForNotExist != null) {
                if (bl) {
                    charArrayWriter.write(" AND");
                } else {
                    charArrayWriter.write(" WHERE");
                }
                charArrayWriter.write(" NOT EXISTS(");
                this.writeSelect(charArrayWriter, this.selectCallForNotExist, this.tableAliasInSelectCallForNotExist, sQLCall);
                charArrayWriter.write(")");
            }
            sQLCall.setSQLString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return sQLCall;
    }

    protected void writeSelect(Writer writer, SQLCall sQLCall, String string, SQLCall sQLCall2) throws IOException {
        String string2 = sQLCall.getSQLString();
        writer.write(string2);
        boolean bl = string2.toUpperCase().indexOf(" WHERE ") >= 0;
        for (int i = 0; i < this.originalFields.size(); ++i) {
            if (i == 0 && !bl) {
                writer.write(" WHERE ");
            } else {
                writer.write(" AND ");
            }
            if (string != null) {
                writer.write(string);
                writer.write(46);
            }
            writer.write(((DatabaseField)this.aliasedFields.elementAt(i)).getName());
            writer.write(" = ");
            writer.write(this.table.getQualifiedName());
            writer.write(46);
            writer.write(((DatabaseField)this.originalFields.elementAt(i)).getName());
        }
        sQLCall2.getParameters().addAll(sQLCall.getParameters());
        sQLCall2.getParameterTypes().addAll(sQLCall.getParameterTypes());
    }

    protected boolean writeWhere(Writer writer, SQLCall sQLCall, SQLCall sQLCall2) throws IOException {
        String string = this.selectCallForExist.getSQLString();
        int n = string.toUpperCase().indexOf(" WHERE ");
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n);
        writer.write(string2);
        sQLCall2.getParameters().addAll(sQLCall.getParameters());
        sQLCall2.getParameterTypes().addAll(sQLCall.getParameterTypes());
        return true;
    }
}

